/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tag.internal.selector;

import com.xpn.xwiki.XWikiContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.tag.internal.TagException;
import org.xwiki.tag.internal.selector.AbstractTagsSelector;

@Component
@Named(value="unsafe")
@Singleton
public class UnsafeTagsSelector
extends AbstractTagsSelector {
    public static final String HINT = "unsafe";

    @Override
    public List<String> getAllTags() throws TagException {
        String hql = "select distinct elements(prop.list) from XWikiDocument as doc, BaseObject as obj, DBStringListProperty as prop where obj.name=doc.fullName and obj.className='XWiki.TagClass' and obj.id=prop.id.id and prop.id.name='tags'";
        try {
            List results = ((XWikiContext)this.contextProvider.get()).getWiki().getStore().getQueryManager().createQuery(hql, "hql").addFilter(this.hiddenDocumentQueryFilter).execute();
            results.sort(String.CASE_INSENSITIVE_ORDER);
            return results;
        }
        catch (QueryException e) {
            throw new TagException(String.format("Failed to get all tags for query [%s]", hql), e);
        }
    }

    @Override
    public Map<String, Integer> getTagCountForQuery(String fromHql, String whereHql, List<?> parameterValues) throws TagException {
        return this.internalGetTagCountForQuery(fromHql, whereHql, parameterValues);
    }

    @Override
    public Map<String, Integer> getTagCountForQuery(String fromHql, String whereHql, Map<String, ?> parameters) throws TagException {
        return this.internalGetTagCountForQuery(fromHql, whereHql, parameters);
    }

    private Map<String, Integer> internalGetTagCountForQuery(String fromHql, String whereHql, Object parameters) throws TagException {
        List results;
        TreeMap<String, Integer> tagCount = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        Object from = "select elements(prop.list) from XWikiDocument as doc, BaseObject as tagobject, DBStringListProperty as prop";
        Object where = " where tagobject.name=doc.fullName and tagobject.className='XWiki.TagClass' and tagobject.id=prop.id.id and prop.id.name='tags' and doc.translation=0";
        if (!StringUtils.isBlank((CharSequence)fromHql) || !StringUtils.isBlank((CharSequence)whereHql)) {
            from = (String)from + fromHql;
        }
        if (!StringUtils.isBlank((CharSequence)whereHql)) {
            where = (String)where + " and " + whereHql;
        }
        String hql = (String)from + (String)where;
        try {
            Query query = ((XWikiContext)this.contextProvider.get()).getWiki().getStore().getQueryManager().createQuery(hql, "hql");
            if (parameters != null) {
                if (parameters instanceof Map) {
                    query.bindValues((Map)parameters);
                } else {
                    query.bindValues((List)parameters);
                }
            }
            query.addFilter(this.hiddenDocumentQueryFilter);
            results = query.execute();
        }
        catch (QueryException e) {
            throw new TagException(String.format("Failed to get tag count for query [%s], with parameters [%s]", hql, parameters), e);
        }
        results.sort(String.CASE_INSENSITIVE_ORDER);
        HashMap<String, String> processedTags = new HashMap<String, String>();
        for (String result : results) {
            String lowerTag = result.toLowerCase();
            processedTags.putIfAbsent(lowerTag, result);
            String tagCountKey = (String)processedTags.get(lowerTag);
            tagCount.compute(tagCountKey, (s, count) -> count == null ? 1 : count + 1);
        }
        return tagCount;
    }

    @Override
    boolean isUnsafe() {
        return true;
    }
}

