/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tag.internal.selector;

import com.xpn.xwiki.XWikiContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.security.authorization.Right;
import org.xwiki.tag.internal.TagException;
import org.xwiki.tag.internal.selector.AbstractTagsSelector;

@Component
@Named(value="exhaustive")
@Singleton
public class ExhaustiveCheckTagsSelector
extends AbstractTagsSelector {
    public static final String HINT = "exhaustive";

    @Override
    public List<String> getAllTags() throws TagException {
        String hql = "select distinct doc.fullName as fullName, elements(prop.list) from XWikiDocument as doc, BaseObject as obj, DBStringListProperty as prop where obj.name=doc.fullName and obj.className='XWiki.TagClass' and obj.id=prop.id.id and prop.id.name='tags' order by fullName";
        try {
            List results = ((XWikiContext)this.contextProvider.get()).getWiki().getStore().getQueryManager().createQuery(hql, "hql").addFilter(this.hiddenDocumentQueryFilter).execute();
            return this.computedTagsFromQuery(results);
        }
        catch (QueryException e) {
            throw new TagException(String.format("Failed to get all tags for query [%s]", hql), e);
        }
    }

    @Override
    public Map<String, Integer> getTagCountForQuery(String fromHql, String whereHql, List<?> parameterValues) throws TagException {
        return this.getTagsFromViewableDocuments(fromHql, whereHql, parameterValues);
    }

    private List<String> computedTagsFromQuery(List<Object[]> results) {
        HashSet<String> tagsSet = new HashSet<String>();
        String previousDoc = null;
        boolean previousDocViewRight = false;
        for (Object[] cols : results) {
            String documentReferenceStr = (String)cols[0];
            String tag = (String)cols[1];
            if (tagsSet.contains(tag)) continue;
            if (!Objects.equals(previousDoc, documentReferenceStr)) {
                DocumentReference documentReference = this.stringDocumentReferenceResolver.resolve((Object)documentReferenceStr, new Object[0]);
                previousDocViewRight = this.contextualAuthorizationManager.hasAccess(Right.VIEW, (EntityReference)documentReference);
                previousDoc = documentReferenceStr;
            }
            if (!previousDocViewRight) continue;
            tagsSet.add(tag);
        }
        ArrayList<String> tagsList = new ArrayList<String>(tagsSet);
        tagsList.sort(String.CASE_INSENSITIVE_ORDER);
        return tagsList;
    }

    @Override
    public Map<String, Integer> getTagCountForQuery(String fromHql, String whereHql, Map<String, ?> parameters) throws TagException {
        return this.getTagsFromViewableDocuments(fromHql, whereHql, parameters);
    }

    private Map<String, Integer> getTagsFromViewableDocuments(String fromHql, String whereHql, Object parameters) throws TagException {
        Object from = "select distinct doc.fullName as fullName, elements(prop.list) from XWikiDocument as doc, BaseObject as tagobject, DBStringListProperty as prop";
        Object where = " where tagobject.name=doc.fullName and tagobject.className='XWiki.TagClass' and tagobject.id=prop.id.id and prop.id.name='tags' and doc.translation=0";
        if (!StringUtils.isBlank((CharSequence)fromHql) || !StringUtils.isBlank((CharSequence)whereHql)) {
            from = (String)from + fromHql;
        }
        if (!StringUtils.isBlank((CharSequence)whereHql)) {
            where = (String)where + " and " + whereHql;
        }
        String hql = (String)from + (String)where + " order by fullName";
        try {
            Query query = ((XWikiContext)this.contextProvider.get()).getWiki().getStore().getQueryManager().createQuery(hql, "hql").addFilter(this.hiddenDocumentQueryFilter);
            if (parameters != null) {
                if (parameters instanceof Map) {
                    query.bindValues((Map)parameters);
                } else {
                    query.bindValues((List)parameters);
                }
            }
            return this.computeCountsFromQuery(query.execute());
        }
        catch (QueryException e) {
            throw new TagException(String.format("Failed to get tag count for query [%s], with parameters [%s]", hql, parameters), e);
        }
    }

    private Map<String, Integer> computeCountsFromQuery(List<Object[]> results) {
        TreeMap<String, Integer> counts = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        String previousDoc = null;
        boolean previousDocViewRight = false;
        for (Object[] cols : results) {
            String documentReferenceStr = (String)cols[0];
            if (!Objects.equals(previousDoc, documentReferenceStr)) {
                DocumentReference documentReference = this.stringDocumentReferenceResolver.resolve((Object)documentReferenceStr, new Object[0]);
                previousDocViewRight = this.contextualAuthorizationManager.hasAccess(Right.VIEW, (EntityReference)documentReference);
                previousDoc = documentReferenceStr;
            }
            if (!previousDocViewRight) continue;
            counts.compute((String)cols[1], (s, count) -> count == null ? 1 : count + 1);
        }
        return counts;
    }
}

