/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tag.internal.selector;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.tag.internal.TagException;
import org.xwiki.tag.internal.TagsSelector;

@Component
@Singleton
public class DefaultTagsSelector
implements TagsSelector,
Initializable {
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configurationSource;
    @Inject
    @Named(value="exhaustive")
    private TagsSelector exhaustiveTagsSelector;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    private TagsSelector tagsSelector;

    public void initialize() throws InitializationException {
        String hint = (String)this.configurationSource.getProperty("tag.rightCheckStrategy.hint");
        if (hint == null) {
            this.tagsSelector = this.exhaustiveTagsSelector;
        } else {
            try {
                this.tagsSelector = (TagsSelector)this.componentManager.getInstance(TagsSelector.class, hint);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to get component [{}] with hint [{}]. Falling back to [{}].", new Object[]{TagsSelector.class, hint, "exhaustive"});
                this.tagsSelector = this.exhaustiveTagsSelector;
            }
        }
    }

    @Override
    public List<String> getAllTags() throws TagException {
        return this.tagsSelector.getAllTags();
    }

    @Override
    public Map<String, Integer> getTagCountForQuery(String fromHql, String whereHql, List<?> parameterValues) throws TagException {
        return this.tagsSelector.getTagCountForQuery(fromHql, whereHql, parameterValues);
    }

    @Override
    public Map<String, Integer> getTagCountForQuery(String fromHql, String whereHql, Map<String, ?> parameters) throws TagException {
        return this.tagsSelector.getTagCountForQuery(fromHql, whereHql, parameters);
    }

    @Override
    public List<String> getDocumentsWithTag(String tag, boolean includeHiddenDocuments, boolean caseSensitive) throws TagException {
        return this.tagsSelector.getDocumentsWithTag(tag, includeHiddenDocuments, caseSensitive);
    }
}

