/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.tag;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.DBStringListProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.tag.TagOperationResult;
import com.xpn.xwiki.plugin.tag.TagParamUtils;
import com.xpn.xwiki.plugin.tag.TagPluginApi;
import com.xpn.xwiki.plugin.tag.TagQueryUtils;
import com.xpn.xwiki.web.Utils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.user.UserReferenceResolver;

public class TagPlugin
extends XWikiDefaultPlugin
implements XWikiPluginInterface {
    public static final Logger LOGGER = LoggerFactory.getLogger(TagPlugin.class);
    public static final String PLUGIN_NAME = "tag";
    public static final String TAG_CLASS = "XWiki.TagClass";
    public static final String TAG_PROPERTY = "tags";
    public static final String DOC_COMMENT_TAG_ADDED = "plugin.tag.editcomment.added";
    private static final Pattern LIKE_ESCAPE = Pattern.compile("[_%\\\\]");
    private static final String LIKE_REPLACEMENT = "\\\\$0";
    private static final String LIKE_APPEND = ".%";
    private UserReferenceResolver<DocumentReference> documentReferenceUserReferenceResolver;

    public TagPlugin(String name, String className, XWikiContext context) {
        super(PLUGIN_NAME, className, context);
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new TagPluginApi((TagPlugin)plugin, context);
    }

    private UserReferenceResolver getUserReferenceResolver() {
        if (this.documentReferenceUserReferenceResolver == null) {
            this.documentReferenceUserReferenceResolver = (UserReferenceResolver)Utils.getComponent((Type)UserReferenceResolver.TYPE_DOCUMENT_REFERENCE, (String)"document");
        }
        return this.documentReferenceUserReferenceResolver;
    }

    private List<String> getTagsFromDocument(XWikiDocument document) {
        try {
            BaseProperty prop = (BaseProperty)document.getObject(TAG_CLASS).safeget(TAG_PROPERTY);
            List tags = (List)prop.getValue();
            if (tags != null) {
                return new ArrayList<String>(tags);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new ArrayList<String>();
    }

    private void setDocumentTags(XWikiDocument document, List<String> tags, XWikiContext context) {
        BaseProperty prop = (BaseProperty)document.getObject(TAG_CLASS, true, context).safeget(TAG_PROPERTY);
        if (prop == null) {
            prop = this.createTagProperty(document.getObject(TAG_CLASS, true, context), context);
        }
        prop.setValue(tags);
    }

    private BaseProperty createTagProperty(BaseObject tagObject, XWikiContext context) {
        DBStringListProperty tagProperty;
        try {
            BaseClass tagClass = context.getWiki().getClass(TAG_CLASS, context);
            PropertyClass tagPropertyDefinition = (PropertyClass)tagClass.getField(TAG_PROPERTY);
            tagProperty = tagPropertyDefinition.newProperty();
        }
        catch (XWikiException ex) {
            LOGGER.warn("Failed to properly create tag property for the tag object, creating a default one");
            tagProperty = new DBStringListProperty();
        }
        tagProperty.setName(TAG_PROPERTY);
        tagProperty.setObject((BaseCollection)tagObject);
        tagObject.safeput(TAG_PROPERTY, (PropertyInterface)tagProperty);
        return tagProperty;
    }

    public List<String> getAllTags(XWikiContext context) throws XWikiException {
        return TagQueryUtils.getAllTags(context);
    }

    public Map<String, Integer> getTagCount(XWikiContext context) throws XWikiException {
        return this.getTagCountForQuery(null, null, context);
    }

    public Map<String, Integer> getTagCount(String spaceReference, XWikiContext context) throws XWikiException {
        if (!StringUtils.isBlank((CharSequence)spaceReference)) {
            String escapedSpaceReference = LIKE_ESCAPE.matcher(spaceReference).replaceAll(LIKE_REPLACEMENT);
            return this.getTagCountForQuery("", "(doc.space = ?1 OR doc.space LIKE ?2)", Arrays.asList(spaceReference, escapedSpaceReference + LIKE_APPEND), context);
        }
        return this.getTagCount(context);
    }

    public Map<String, Integer> getTagCountForSpaces(String spaces, XWikiContext context) throws XWikiException {
        List<String> spaceRefList = TagParamUtils.spacesParameterToList(spaces);
        ArrayList<Object> queryParameters = new ArrayList<Object>();
        StringBuilder where = new StringBuilder();
        boolean first = true;
        int parameterIndex = 1;
        for (String spaceReference : spaceRefList) {
            if (first) {
                where.append("(");
                first = false;
            } else {
                where.append(" OR ");
            }
            where.append("doc.space = ?");
            where.append(parameterIndex++);
            where.append(' ');
            queryParameters.add(spaceReference);
            where.append("OR doc.space LIKE ?");
            where.append(parameterIndex++);
            String escapedSpaceReference = LIKE_ESCAPE.matcher(spaceReference).replaceAll(LIKE_REPLACEMENT);
            queryParameters.add(escapedSpaceReference + LIKE_APPEND);
        }
        if (!first) {
            where.append(')');
        }
        return this.getTagCountForQuery("", where.toString(), queryParameters, context);
    }

    public Map<String, Integer> getTagCountForQuery(String fromHql, String whereHql, XWikiContext context) throws XWikiException {
        return this.getTagCountForQuery(fromHql, whereHql, (Map)null, context);
    }

    public Map<String, Integer> getTagCountForQuery(String fromHql, String whereHql, List<?> parameterValues, XWikiContext context) throws XWikiException {
        return TagQueryUtils.getTagCountForQuery(fromHql, whereHql, parameterValues, context);
    }

    public Map<String, Integer> getTagCountForQuery(String fromHql, String whereHql, Map<String, ?> parameters, XWikiContext context) throws XWikiException {
        return TagQueryUtils.getTagCountForQuery(fromHql, whereHql, parameters, context);
    }

    public List<String> getDocumentsWithTag(String tag, XWikiContext context) throws XWikiException {
        return TagQueryUtils.getDocumentsWithTag(tag, false, false);
    }

    public List<String> getDocumentsWithTag(String tag, boolean includeHiddenDocuments, XWikiContext context) throws XWikiException {
        return this.getDocumentsWithTag(tag, includeHiddenDocuments, false);
    }

    private List<String> getDocumentsWithTag(String tag, boolean includeHiddenDocuments, boolean caseSensitive) throws XWikiException {
        return TagQueryUtils.getDocumentsWithTag(tag, includeHiddenDocuments, caseSensitive);
    }

    public List<String> getTagsFromDocument(String documentName, XWikiContext context) throws XWikiException {
        return this.getTagsFromDocument(context.getWiki().getDocument(documentName, context));
    }

    public List<String> getTagsFromDocument(XWikiDocument document, XWikiContext context) throws XWikiException {
        return this.getTagsFromDocument(document);
    }

    public TagOperationResult addTagToDocument(String tag, String documentName, XWikiContext context) throws XWikiException {
        XWikiDocument document = context.getWiki().getDocument(documentName, context);
        document = document.clone();
        return this.addTagToDocument(tag, document, context);
    }

    public TagOperationResult addTagToDocument(String tag, XWikiDocument document, XWikiContext context) throws XWikiException {
        List<String> tags = this.getTagsFromDocument(document);
        if (!StringUtils.isBlank((CharSequence)tag) && !tags.contains(tag)) {
            tags.add(tag);
            this.setDocumentTags(document, tags, context);
            String comment = this.localizePlainOrKey(DOC_COMMENT_TAG_ADDED, new Object[]{tag});
            document.getAuthors().setOriginalMetadataAuthor(this.getUserReferenceResolver().resolve((Object)context.getUserReference(), new Object[0]));
            context.getWiki().saveDocument(document, comment, true, context);
            return TagOperationResult.OK;
        }
        return TagOperationResult.NO_EFFECT;
    }

    public TagOperationResult addTagsToDocument(String tags, String documentName, XWikiContext context) throws XWikiException {
        XWikiDocument document = context.getWiki().getDocument(documentName, context);
        document = document.clone();
        return this.addTagsToDocument(tags, document, context);
    }

    public TagOperationResult addTagsToDocument(String tags, XWikiDocument document, XWikiContext context) throws XWikiException {
        List<String> documentTags = this.getTagsFromDocument(document);
        String[] newTags = tags.trim().split("\\s*+,\\s*+");
        boolean added = false;
        for (String tag : newTags) {
            if (StringUtils.isBlank((CharSequence)tag) || this.containsIgnoreCase(documentTags, tag)) continue;
            documentTags.add(tag);
            added = true;
        }
        if (added) {
            this.setDocumentTags(document, documentTags, context);
            String comment = this.localizePlainOrKey(DOC_COMMENT_TAG_ADDED, new Object[]{tags});
            document.setAuthorReference(context.getUserReference());
            context.getWiki().saveDocument(document, comment, true, context);
            return TagOperationResult.OK;
        }
        return TagOperationResult.NO_EFFECT;
    }

    private boolean containsIgnoreCase(Collection<String> collection, String item) {
        for (String existingItem : collection) {
            if (!existingItem.equalsIgnoreCase(item)) continue;
            return true;
        }
        return false;
    }

    public TagOperationResult removeTagFromDocument(String tag, String documentName, XWikiContext context) throws XWikiException {
        XWikiDocument document = context.getWiki().getDocument(documentName, context);
        document = document.clone();
        return this.removeTagFromDocument(tag, document, context);
    }

    public TagOperationResult removeTagFromDocument(String tag, XWikiDocument document, XWikiContext context) throws XWikiException {
        List<String> tags = this.getTagsFromDocument(document);
        boolean needsUpdate = false;
        ListIterator<String> it = tags.listIterator();
        while (it.hasNext()) {
            if (!tag.equalsIgnoreCase(it.next())) continue;
            needsUpdate = true;
            it.remove();
        }
        if (needsUpdate) {
            this.setDocumentTags(document, tags, context);
            String comment = this.localizePlainOrKey("plugin.tag.editcomment.removed", new Object[]{tag});
            document.setAuthorReference(context.getUserReference());
            context.getWiki().saveDocument(document, comment, true, context);
            return TagOperationResult.OK;
        }
        return TagOperationResult.NO_EFFECT;
    }

    protected TagOperationResult renameTag(String tag, String newTag, XWikiContext context) throws XWikiException {
        boolean caseSensitive = StringUtils.equalsIgnoreCase((CharSequence)tag, (CharSequence)newTag);
        List<String> docNamesToProcess = this.getDocumentsWithTag(tag, true, caseSensitive);
        if (Strings.CS.equals(tag, newTag) || docNamesToProcess.isEmpty() || StringUtils.isBlank((CharSequence)newTag)) {
            return TagOperationResult.NO_EFFECT;
        }
        String comment = this.localizePlainOrKey("plugin.tag.editcomment.renamed", new Object[]{tag, newTag});
        for (String docName : docNamesToProcess) {
            XWikiDocument doc = context.getWiki().getDocument(docName, context);
            List<String> tags = this.getTagsFromDocument(doc = doc.clone());
            if (tags.contains(newTag)) {
                this.removeTagFromDocument(tag, doc.getFullName(), context);
                continue;
            }
            for (int i = 0; i < tags.size(); ++i) {
                if (!tags.get(i).equalsIgnoreCase(tag)) continue;
                tags.set(i, newTag);
            }
            this.setDocumentTags(doc, tags, context);
            doc.setAuthorReference(context.getUserReference());
            context.getWiki().saveDocument(doc, comment, true, context);
        }
        return TagOperationResult.OK;
    }

    protected TagOperationResult deleteTag(String tag, XWikiContext context) throws XWikiException {
        List<String> docsToProcess = this.getDocumentsWithTag(tag, true, context);
        if (docsToProcess.size() == 0) {
            return TagOperationResult.NO_EFFECT;
        }
        for (String docName : docsToProcess) {
            this.removeTagFromDocument(tag, docName, context);
        }
        return TagOperationResult.OK;
    }
}

