/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.tag;

import com.xpn.xwiki.XWikiException;
import java.util.ArrayList;
import java.util.List;

public final class TagParamUtils {
    private TagParamUtils() {
    }

    public static List<String> spacesParameterToList(String spaces) throws XWikiException {
        if (spaces == null) {
            throw new IllegalArgumentException("Parameter 'spaces' should not be null");
        }
        return new HQLInListParser(spaces).getResults();
    }

    private static class HQLInListParser {
        private final String spaces;
        private boolean inQuotes;
        private boolean commaSeen = true;
        private int pos;
        private char c;
        private StringBuilder space;
        private final List<String> results = new ArrayList<String>();

        HQLInListParser(String spaces) throws XWikiException {
            this.spaces = spaces;
            this.parse();
        }

        List<String> getResults() {
            return this.results;
        }

        private void parse() throws XWikiException {
            while (this.pos < this.spaces.length()) {
                this.c = this.spaces.charAt(this.pos++);
                if (this.inQuotes) {
                    this.handleInQuotes();
                    continue;
                }
                this.handleOutsideQuotes();
            }
            if (this.inQuotes) {
                throw new XWikiException(5, 0, String.format("Missing closing quote in [%s]", this.spaces));
            }
            if (this.commaSeen && !this.results.isEmpty()) {
                throw new XWikiException(5, 0, String.format("Unexpected comma at end of [%s]", this.spaces));
            }
        }

        private void handleInQuotes() {
            if (this.c == '\'') {
                if (this.pos < this.spaces.length() && this.spaces.charAt(this.pos) == '\'') {
                    ++this.pos;
                    this.space.append(this.c);
                } else {
                    this.results.add(this.space.toString());
                    this.inQuotes = false;
                    this.commaSeen = false;
                }
            } else {
                this.space.append(this.c);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void handleOutsideQuotes() throws XWikiException {
            if (this.c == ',') {
                if (this.commaSeen) {
                    throw new XWikiException(5, 0, String.format("Unexpected comma at position %d in [%s]", this.pos, this.spaces));
                }
                this.commaSeen = true;
                return;
            } else if (this.c == '\'') {
                if (!this.commaSeen) throw new XWikiException(5, 0, String.format("Unexpected quote at position %d in [%s]", this.pos, this.spaces));
                this.inQuotes = true;
                this.space = new StringBuilder();
                return;
            } else {
                if (Character.isWhitespace(this.c)) return;
                throw new XWikiException(5, 0, String.format("Unexpected character `%s` at position %d in [%s]", Character.valueOf(this.c), this.pos, this.spaces));
            }
        }
    }
}

