/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.serialization.xml.internal;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Stack;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;

public class XMLWriter
extends org.dom4j.io.XMLWriter {
    private static final int BASE64_WIDTH = 80;
    private static final byte[] NEWLINE;
    private static final char CLOSE_ANGLE_BRACKET = '>';
    protected Stack<Element> parent = new Stack();
    private OutputStream out;
    private LastCharWriter lcWriter;

    protected XMLWriter() {
    }

    public XMLWriter(OutputStream out, OutputFormat format) throws UnsupportedEncodingException {
        super(out, format);
        this.lcWriter = new LastCharWriter(this.writer);
        this.writer = this.lcWriter;
        this.out = out;
    }

    public void writeDocumentStart(Document doc) throws IOException {
        this.writeDeclaration();
        if (doc.getDocType() != null) {
            super.indent();
            super.writeDocType(doc.getDocType());
        }
    }

    public void writeDocumentEnd(Document doc) throws IOException {
        if (!this.parent.isEmpty()) {
            this.writeClose((Element)this.parent.firstElement());
        }
        super.writePrintln();
        super.flush();
    }

    public void write(Element element, Reader rd) throws IOException {
        this.writeOpen(element);
        IOUtils.copy((Reader)rd, (Writer)this.lcWriter);
        this.writeClose(element);
    }

    public void write(Element element, InputStream is) throws IOException {
        this.writeOpen(element);
        super.flush();
        IOUtils.copy((InputStream)is, (OutputStream)this.out);
        super.writeClose(element);
    }

    public void writeBase64(Element element, InputStream is) throws IOException {
        this.writeOpen(element);
        super.writePrintln();
        super.flush();
        Base64OutputStream base64 = new Base64OutputStream((OutputStream)new CloseShieldOutputStream(this.out), true, 80, NEWLINE);
        IOUtils.copy((InputStream)is, (OutputStream)base64);
        base64.close();
        super.setIndentLevel(this.parent.size() - 1);
        super.indent();
        this.writeClose(element);
    }

    public void writeOpen(Element element) throws IOException {
        if (this.lcWriter.getLastChar() == '>') {
            super.writePrintln();
            super.indent();
        }
        super.writeOpen(element);
        this.parent.push(element);
        super.setIndentLevel(this.parent.size());
    }

    public void writeClose(Element element) throws IOException {
        while (!this.parent.peek().getQualifiedName().equals(element.getQualifiedName())) {
            this.writeClose(this.parent.peek());
        }
        super.setIndentLevel(this.parent.size() - 1);
        if (this.lcWriter.getLastChar() == '>') {
            super.writePrintln();
            super.indent();
        }
        super.writeClose(this.parent.pop());
    }

    static {
        try {
            NEWLINE = System.getProperty("line.separator").getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("No UTF-8, this Java VM is not standards compliant!", e);
        }
    }

    private static class LastCharWriter
    extends FilterWriter {
        private char lastChar;

        LastCharWriter(Writer toWrap) {
            super(toWrap);
        }

        @Override
        public void write(char[] buffer, int offset, int count) throws IOException {
            super.write(buffer, offset, count);
            this.lastChar = buffer[offset + count - 1];
        }

        @Override
        public void write(String str, int offset, int count) throws IOException {
            super.write(str, offset, count);
            this.lastChar = str.charAt(offset + count - 1);
        }

        @Override
        public void write(int oneChar) throws IOException {
            super.write(oneChar);
            this.lastChar = (char)oneChar;
        }

        public char getLastChar() {
            return this.lastChar;
        }
    }
}

