/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.serialization.xml.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;
import org.xwiki.component.annotation.ComponentRole;
import org.xwiki.store.serialization.xml.XMLSerializer;
import org.xwiki.store.serialization.xml.internal.XMLWriter;

@ComponentRole
public abstract class AbstractXMLSerializer<R, P extends R>
implements XMLSerializer<R, P> {
    @Override
    public InputStream serialize(R object) throws IOException {
        XMLWriter writer;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            OutputFormat of = new OutputFormat(" ", true, "UTF-8");
            writer = new XMLWriter(baos, of);
            writer.startDocument();
        }
        catch (SAXException e) {
            throw new IOException("Could not open the XML writer.");
        }
        this.serialize(object, writer);
        try {
            writer.endDocument();
        }
        catch (SAXException e) {
            throw new IOException("Could not close the XML writer.");
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    @Override
    public P parse(InputStream stream) throws IOException {
        Document domdoc;
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (SAXException e) {
            throw new IOException("Failure to set secure XML processing", e);
        }
        reader.setStripWhitespaceText(true);
        reader.setMergeAdjacentText(true);
        try {
            domdoc = reader.read(stream);
        }
        catch (DocumentException e) {
            throw new IOException("Failed to parse XML, probably malformed input.");
        }
        return this.parse(domdoc.getRootElement());
    }
}

