/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.merge;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.Conflict;
import org.xwiki.diff.ConflictDecision;
import org.xwiki.diff.internal.DefaultConflictDecision;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.store.merge.MergeConflictDecisionsManager;
import org.xwiki.store.merge.MergeDocumentResult;
import org.xwiki.store.merge.MergeDocumentResultScript;
import org.xwiki.store.merge.MergeManager;

@Component
@Named(value="merge")
@Singleton
public class MergeScriptService
implements ScriptService {
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private MergeConflictDecisionsManager conflictDecisionsManager;
    @Inject
    private MergeManager mergeManager;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;

    public MergeDocumentResultScript mergeDocument(Document previousDocument, Document currentDocument, Document newDocument) {
        MergeConfiguration mergeConfiguration = new MergeConfiguration();
        mergeConfiguration.setProvidedVersionsModifiables(false);
        XWikiDocument previousDoc = previousDocument.getDocument();
        XWikiDocument currentDoc = currentDocument.getDocument();
        XWikiDocument newDoc = newDocument.getDocument();
        MergeDocumentResult mergeResult = this.mergeManager.mergeDocument((DocumentModelBridge)previousDoc, (DocumentModelBridge)newDoc, (DocumentModelBridge)currentDoc, mergeConfiguration);
        return new MergeDocumentResultScript(mergeResult, (XWikiContext)this.contextProvider.get(), this.contextualAuthorizationManager.hasAccess(Right.PROGRAM));
    }

    public ConflictDecision<String> getDecision(Conflict<String> conflict, ConflictDecision.DecisionType type, String customDecision) {
        DefaultConflictDecision conflictDecision = new DefaultConflictDecision(conflict);
        if (StringUtils.isEmpty((CharSequence)customDecision)) {
            conflictDecision.setType(type);
        } else {
            conflictDecision.setCustom(Collections.singletonList(customDecision));
        }
        return conflictDecision;
    }

    public void recordDecisions(List<ConflictDecision> decisionList) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        this.conflictDecisionsManager.setConflictDecisionList(decisionList, context.getDoc().getDocumentReferenceWithLocale(), (EntityReference)context.getUserReference());
    }
}

