/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.merge;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.xwiki.diff.Conflict;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogQueue;

public class MergeManagerResult<R, C> {
    private final List<Conflict<C>> conflicts = new ArrayList<Conflict<C>>();
    private R mergeResult;
    private LogQueue log = new LogQueue();
    private boolean modified = false;

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void addConflicts(List<Conflict<C>> conflicts) {
        this.conflicts.addAll(conflicts);
    }

    public List<Conflict<C>> getConflicts() {
        return this.conflicts;
    }

    public int getConflictsNumber() {
        return this.log.getLogs(LogLevel.ERROR).size() - this.conflicts.size() + this.conflicts.size();
    }

    public void setMergeResult(R result) {
        this.mergeResult = result;
    }

    public R getMergeResult() {
        return this.mergeResult;
    }

    public void setLog(LogQueue logQueue) {
        this.log = logQueue;
    }

    public LogQueue getLog() {
        return this.log;
    }

    public boolean hasConflicts() {
        return !this.getConflicts().isEmpty() || !this.log.getLogs(LogLevel.ERROR).isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeManagerResult that = (MergeManagerResult)o;
        return new EqualsBuilder().append(this.modified, that.modified).append(this.conflicts, that.conflicts).append(this.mergeResult, that.mergeResult).append(this.hasConflicts(), that.hasConflicts()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(69, 33).append(this.conflicts).append(this.mergeResult).append(this.hasConflicts()).append(this.modified).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("conflicts", this.conflicts).append("mergeResult", this.mergeResult).append("log", (Object)this.log).append("modified", this.modified).toString();
    }
}

