/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.Part;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.attachment.validation.AttachmentValidationException;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.store.TemporaryAttachmentException;
import org.xwiki.store.TemporaryAttachmentSessionsManager;
import org.xwiki.store.filesystem.StoreFilesystemOldcoreException;

@Component
@Singleton
@Named(value="temporaryAttachments")
public class TemporaryAttachmentsScriptService
implements ScriptService {
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private TemporaryAttachmentSessionsManager temporaryAttachmentSessionsManager;
    @Inject
    private Logger logger;

    public Attachment uploadTemporaryAttachment(DocumentReference documentReference, String fieldName) throws TemporaryAttachmentException, AttachmentValidationException {
        return this.uploadTemporaryAttachment(documentReference, fieldName, null);
    }

    public Attachment uploadTemporaryAttachment(DocumentReference documentReference, String fieldName, String filename) throws TemporaryAttachmentException, AttachmentValidationException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            Part part = context.getRequest().getPart(fieldName);
            if (part != null) {
                XWikiAttachment attachment = this.temporaryAttachmentSessionsManager.uploadAttachment(documentReference, part, filename);
                Document document = Optional.ofNullable(attachment.getDoc()).map(doc -> doc.newDocument(context)).orElse(null);
                return new Attachment(document, attachment, context);
            }
            return null;
        }
        catch (IOException | ServletException e) {
            this.logger.warn("Error while reading the request content part: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    public List<Attachment> listTemporaryAttachments(DocumentReference documentReference) throws StoreFilesystemOldcoreException {
        XWikiDocument document = this.getDocument(documentReference);
        return this.temporaryAttachmentSessionsManager.getUploadedAttachments(documentReference).stream().map(attachment -> this.convertToAttachment(document, (XWikiAttachment)attachment)).sorted(TemporaryAttachmentsScriptService.getLowerCaseStringComparator()).collect(Collectors.toList());
    }

    public List<Attachment> listAllAttachments(DocumentReference documentReference) throws StoreFilesystemOldcoreException {
        ArrayList temporaryAttachments = new ArrayList(this.temporaryAttachmentSessionsManager.getUploadedAttachments(documentReference));
        XWikiDocument document = this.getDocument(documentReference);
        List<Attachment> fullList = temporaryAttachments.stream().map(attachment -> this.convertToAttachment(document, (XWikiAttachment)attachment)).collect(Collectors.toList());
        Stream<Attachment> nonOverriddenAttachments = document.getAttachmentList().stream().map(xWikiAttachment -> this.convertToAttachment(document, (XWikiAttachment)xWikiAttachment)).filter(persistedAttachment -> temporaryAttachments.stream().map(xWikiAttachment -> this.convertToAttachment(document, (XWikiAttachment)xWikiAttachment)).noneMatch(this.attachmentEqualityPredicate((Attachment)persistedAttachment)));
        fullList.addAll(nonOverriddenAttachments.collect(Collectors.toList()));
        fullList.sort(TemporaryAttachmentsScriptService.getLowerCaseStringComparator());
        return fullList;
    }

    public boolean temporaryAttachmentExists(Attachment attachment) {
        return this.temporaryAttachmentSessionsManager.getUploadedAttachment(attachment.getReference()).isPresent();
    }

    public boolean persistentAttachmentExists(Attachment attachment) throws StoreFilesystemOldcoreException {
        XWikiDocument document = this.getDocument(attachment.getReference().getDocumentReference());
        return document.getAttachment(attachment.getFilename()) != null;
    }

    private Predicate<Attachment> attachmentEqualityPredicate(Attachment attachment0) {
        String attachment0Filename = attachment0.getFilename();
        return attachment1 -> Objects.equals(attachment1.getFilename(), attachment0Filename);
    }

    private XWikiDocument getDocument(DocumentReference documentReference) throws StoreFilesystemOldcoreException {
        try {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            return context.getWiki().getDocument(documentReference, context);
        }
        catch (XWikiException e) {
            throw new StoreFilesystemOldcoreException(String.format("Failed to load document [%s]", documentReference), e);
        }
    }

    private Attachment convertToAttachment(XWikiDocument document, XWikiAttachment attachment) {
        if (attachment == null) {
            return null;
        }
        return new Attachment(new Document(document, (XWikiContext)this.contextProvider.get()), attachment, (XWikiContext)this.contextProvider.get());
    }

    private static Comparator<Attachment> getLowerCaseStringComparator() {
        return Comparator.comparing(attachment -> Objects.toString(attachment.getFilename(), "").toLowerCase());
    }
}

