/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.legacy.store.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import org.xwiki.store.RootTransactionRunnable;
import org.xwiki.store.legacy.store.internal.HibernateTransaction;

public class XWikiHibernateTransaction
extends RootTransactionRunnable
implements HibernateTransaction {
    private final XWikiHibernateBaseStore store;
    private final XWikiContext context;
    private boolean shouldCloseTransaction;

    public XWikiHibernateTransaction(XWikiContext context) {
        this.store = context.getWiki().getHibernateStore();
        this.context = context;
    }

    public void onPreRun() throws XWikiException {
        this.store.checkHibernate(this.context);
    }

    public void onRun() throws XWikiException {
        this.shouldCloseTransaction = this.store.beginTransaction(this.context);
    }

    public void onCommit() {
        if (this.shouldCloseTransaction) {
            this.store.endTransaction(this.context, true);
        }
    }

    public void onRollback() {
        if (this.shouldCloseTransaction) {
            this.store.endTransaction(this.context, false);
        }
    }
}

