/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.legacy.store.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentArchive;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.xwiki.store.FileSaveTransactionRunnable;
import org.xwiki.store.StartableTransactionRunnable;
import org.xwiki.store.StreamProvider;
import org.xwiki.store.StringStreamProvider;
import org.xwiki.store.TransactionRunnable;
import org.xwiki.store.filesystem.internal.DeletedAttachmentFileProvider;
import org.xwiki.store.filesystem.internal.FilesystemStoreTools;
import org.xwiki.store.filesystem.internal.StoreFileUtils;
import org.xwiki.store.legacy.store.internal.AttachmentArchiveSaveRunnable;
import org.xwiki.store.legacy.store.internal.AttachmentContentStreamProvider;
import org.xwiki.store.serialization.SerializationStreamProvider;
import org.xwiki.store.serialization.Serializer;

class SaveDeletedAttachmentContentRunnable
extends StartableTransactionRunnable {
    SaveDeletedAttachmentContentRunnable(XWikiAttachment attachment, DeletedAttachmentFileProvider provider, FilesystemStoreTools fileTools, Serializer<XWikiAttachment, XWikiAttachment> metaSerializer, Serializer<List<XWikiAttachment>, List<XWikiAttachment>> versionSerializer, XWikiContext context) throws XWikiException {
        AttachmentContentStreamProvider streamProvider;
        File finalAttachFile;
        SerializationStreamProvider metaProvider = new SerializationStreamProvider(metaSerializer, (Object)attachment);
        this.addSaver((StreamProvider)metaProvider, fileTools, provider.getDeletedAttachmentMetaFile());
        XWikiAttachmentArchive archive = attachment.loadArchive(context);
        if (archive == null) {
            throw new NullPointerException("Failed to load attachment archive, loadArchive() returned null");
        }
        new AttachmentArchiveSaveRunnable(archive, fileTools, provider, versionSerializer, context).runIn((TransactionRunnable)this);
        File attachFile = provider.getAttachmentContentFile();
        File linkAttachFile = StoreFileUtils.getLinkFile(attachFile);
        XWikiAttachment archiveAttachment = archive.getRevision(attachment, attachment.getVersion(), context);
        if (archiveAttachment != null && Objects.equals(archiveAttachment.getDate(), attachment.getDate()) && archiveAttachment.getLongSize() == attachment.getLongSize()) {
            finalAttachFile = linkAttachFile;
            streamProvider = new StringStreamProvider(fileTools.getLinkContent(attachment), StandardCharsets.UTF_8);
        } else {
            finalAttachFile = attachFile;
            streamProvider = new AttachmentContentStreamProvider(attachment, context);
        }
        this.addSaver(streamProvider, fileTools, finalAttachFile);
    }

    private void addSaver(StreamProvider provider, FilesystemStoreTools fileTools, File saveHere) {
        new FileSaveTransactionRunnable(saveHere, fileTools.getTempFile(saveHere), fileTools.getBackupFile(saveHere), fileTools.getLockForFile(saveHere), provider).runIn((TransactionRunnable)this);
    }
}

