/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.legacy.store.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DeletedAttachmentContent;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentContent;
import com.xpn.xwiki.store.AttachmentRecycleBinContentStore;
import com.xpn.xwiki.store.AttachmentVersioningStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.store.FileDeleteTransactionRunnable;
import org.xwiki.store.StartableTransactionRunnable;
import org.xwiki.store.TransactionRunnable;
import org.xwiki.store.filesystem.internal.DeletedAttachmentFileProvider;
import org.xwiki.store.filesystem.internal.FilesystemStoreTools;
import org.xwiki.store.filesystem.internal.StoreFileUtils;
import org.xwiki.store.legacy.doc.internal.FilesystemAttachmentContent;
import org.xwiki.store.legacy.store.internal.FileDeletedAttachmentContent;
import org.xwiki.store.legacy.store.internal.FilesystemAttachmentVersioningStore;
import org.xwiki.store.legacy.store.internal.SaveDeletedAttachmentContentRunnable;
import org.xwiki.store.serialization.Serializer;

@Component
@Named(value="file")
@Singleton
public class FilesystemAttachmentRecycleBinContentStore
implements AttachmentRecycleBinContentStore,
Initializable {
    @Inject
    private FilesystemStoreTools fileTools;
    @Inject
    @Named(value="attachment-list-meta/1.0")
    private Serializer<List<XWikiAttachment>, List<XWikiAttachment>> versionSerializer;
    @Inject
    @Named(value="deleted-attachment-meta/1.0")
    private Serializer<XWikiAttachment, XWikiAttachment> metaSerializer;
    @Inject
    @Named(value="file")
    private AttachmentVersioningStore attachmentVersionStore;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public String getHint() {
        return "file";
    }

    public void initialize() throws InitializationException {
        if (!(this.attachmentVersionStore instanceof FilesystemAttachmentVersioningStore)) {
            throw new InitializationException("Wrong attachment versioning store registered under hint 'file', expecting a FilesystemAttachmentVersioningStore");
        }
    }

    public void delete(AttachmentReference reference, Date deleteDate, long index, boolean bTransaction) throws XWikiException {
        DeletedAttachmentFileProvider provider = this.fileTools.getDeletedAttachmentFileProvider(reference, index);
        StartableTransactionRunnable tr = this.getDeletedAttachmentPurgeRunnable(provider);
        try {
            tr.start();
        }
        catch (Exception e) {
            throw new XWikiException(3, 0, "Failed to delete deleted attachment [" + String.valueOf(reference) + "]", (Throwable)e);
        }
    }

    private StartableTransactionRunnable getDeletedAttachmentPurgeRunnable(DeletedAttachmentFileProvider provider) {
        StartableTransactionRunnable out = new StartableTransactionRunnable();
        File deletedAttachDir = provider.getDeletedAttachmentMetaFile().getParentFile();
        if (!deletedAttachDir.exists()) {
            return out;
        }
        for (File toDelete : deletedAttachDir.listFiles()) {
            new FileDeleteTransactionRunnable(toDelete, this.fileTools.getBackupFile(toDelete), this.fileTools.getLockForFile(toDelete)).runIn((TransactionRunnable)out);
        }
        return out;
    }

    public DeletedAttachmentContent get(AttachmentReference reference, Date deleteDate, long index, boolean bTransaction) throws XWikiException {
        DeletedAttachmentFileProvider provider = this.fileTools.getDeletedAttachmentFileProvider(reference, index);
        try {
            return this.deletedAttachmentContentFromProvider(provider);
        }
        catch (IOException e) {
            throw new XWikiException(3, 0, "Failed to get deleted attachment [" + String.valueOf(reference) + "] at index [" + index + "] and date  [" + String.valueOf(deleteDate) + "]", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeletedAttachmentContent deletedAttachmentContentFromProvider(DeletedAttachmentFileProvider provider) throws IOException {
        XWikiAttachment attachment;
        File deletedMeta = provider.getDeletedAttachmentMetaFile();
        if (!deletedMeta.exists()) {
            return null;
        }
        ReadWriteLock lock = this.fileTools.getLockForFile(deletedMeta);
        lock.readLock().lock();
        try {
            attachment = (XWikiAttachment)this.metaSerializer.parse((InputStream)new FileInputStream(deletedMeta));
        }
        finally {
            lock.readLock().unlock();
        }
        File contentFile = provider.getAttachmentContentFile();
        contentFile = StoreFileUtils.resolve(contentFile, true);
        attachment.setAttachment_content((XWikiAttachmentContent)new FilesystemAttachmentContent(contentFile, attachment));
        attachment.setContentStore("file");
        attachment.setAttachment_archive(((FilesystemAttachmentVersioningStore)this.attachmentVersionStore).loadArchive(attachment, provider));
        attachment.setArchiveStore("file");
        return new FileDeletedAttachmentContent(attachment);
    }

    public void save(XWikiAttachment attachment, Date deleteDate, long index, boolean bTransaction) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        StartableTransactionRunnable tr = this.getSaveTrashAttachmentRunnable(attachment, index, xcontext);
        new StartableTransactionRunnable().runIn((TransactionRunnable)tr);
        try {
            tr.start();
        }
        catch (Exception e) {
            throw new XWikiException(3, 0, "Failed to store deleted attachment [" + String.valueOf(attachment.getReference()) + "]", (Throwable)e);
        }
    }

    private StartableTransactionRunnable getSaveTrashAttachmentRunnable(XWikiAttachment deleted, long index, XWikiContext context) throws XWikiException {
        DeletedAttachmentFileProvider provider = this.fileTools.getDeletedAttachmentFileProvider(deleted.getReference(), index);
        return new SaveDeletedAttachmentContentRunnable(deleted, provider, this.fileTools, this.metaSerializer, this.versionSerializer, context);
    }
}

