/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.legacy.store.internal;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.filter.XWikiDocumentFilterUtils;
import java.io.File;
import javax.inject.Inject;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filter.instance.input.DocumentInstanceInputProperties;
import org.xwiki.filter.output.DefaultFileOutputTarget;
import org.xwiki.filter.output.OutputTarget;
import org.xwiki.filter.xar.output.XAROutputProperties;
import org.xwiki.store.FileSerializer;

@Component(roles={DeletedDocumentContentFileSerializer.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DeletedDocumentContentFileSerializer
implements FileSerializer {
    @Inject
    private XWikiDocumentFilterUtils serializer;
    private XWikiDocument document;
    private String encoding;

    public void init(XWikiDocument document, String encoding) {
        this.document = document;
        this.encoding = encoding;
    }

    public void serialize(File file) throws Exception {
        DocumentInstanceInputProperties documentProperties = new DocumentInstanceInputProperties();
        documentProperties.setWithRevisions(false);
        documentProperties.setWithJRCSRevisions(true);
        documentProperties.setWithWikiAttachmentJRCSRevisions(false);
        documentProperties.setWithWikiAttachmentsRevisions(true);
        XAROutputProperties xarProperties = new XAROutputProperties();
        xarProperties.setPreserveVersion(true);
        xarProperties.setEncoding(this.encoding);
        xarProperties.setFormat(true);
        try {
            this.serializer.exportEntity((Object)this.document, (OutputTarget)new DefaultFileOutputTarget(file), xarProperties, documentProperties);
        }
        catch (Exception e) {
            throw new XWikiException(2, 2002, "Error parsing xml", (Throwable)e, null);
        }
    }
}

