/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.legacy.doc.internal;

import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.xwiki.store.UnexpectedException;

public class FilesystemAttachmentContent
extends XWikiAttachmentContent {
    private final File storageFile;

    public FilesystemAttachmentContent(File storage, XWikiAttachment attachment) {
        super(attachment, null);
        this.storageFile = storage;
    }

    public FilesystemAttachmentContent(File storage) {
        super(null, null);
        this.storageFile = storage;
    }

    public FilesystemAttachmentContent(FilesystemAttachmentContent filesystemAttachmentContent) {
        super((XWikiAttachmentContent)filesystemAttachmentContent);
        this.storageFile = filesystemAttachmentContent.storageFile;
    }

    public FilesystemAttachmentContent clone() {
        return new FilesystemAttachmentContent(this);
    }

    public boolean exists() {
        return this.storageFile.exists();
    }

    @Deprecated
    public byte[] getContent() {
        if (this.getFileItem() != null) {
            return super.getContent();
        }
        InputStream is = this.getContentInputStream();
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load attachment content", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public InputStream getContentInputStream() {
        if (this.getFileItem() != null) {
            return super.getContentInputStream();
        }
        try {
            return new AutoCloseInputStream((InputStream)new FileInputStream(this.storageFile));
        }
        catch (IOException e) {
            throw new UnexpectedException("Failed to get InputStream", (Throwable)e);
        }
    }

    public long getLongSize() {
        if (this.getFileItem() != null) {
            return super.getLongSize();
        }
        return this.storageFile.length();
    }
}

