/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal.migration;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DeletedAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.store.filesystem.internal.migration.AbstractFileStoreDataMigration;

@Component
@Named(value="R910100XWIKI14871")
@Singleton
public class R910100XWIKI14871DataMigration
extends AbstractFileStoreDataMigration {
    private static final Pattern STORAGE = Pattern.compile("/storage/");
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource configuration;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> serializer;
    private final Set<String> migratedDeletedAttachment = new HashSet<String>();

    public String getDescription() {
        return "Make sure all existing deleted attachments have a store id and move back metadata to the database.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(910100);
    }

    public void hibernateMigrate() throws XWikiException, DataMigrationException {
        this.getStore().executeWrite(this.getXWikiContext(), session -> {
            try {
                this.migrateMetadatas(session);
            }
            catch (Exception e) {
                throw new HibernateException("Failed to move deleted attachments metadata to the database", (Throwable)e);
            }
            return null;
        });
    }

    /*
     * Unable to fully structure code
     */
    private void migrateMetadatas(Session session) throws IOException, XMLStreamException, FactoryConfigurationError, ParserConfigurationException, SAXException, DataMigrationException {
        block11: {
            storageLocationFile = this.getPre11StoreRootDirectory();
            this.logger.info("Migrating filesystem attachment metadatas stored in [{}]", (Object)storageLocationFile);
            pathByIdStore = new File(storageLocationFile, "~GLOBAL_DELETED_ATTACHMENT_ID_MAPPINGS.xml");
            if (!pathByIdStore.exists()) break block11;
            stream = new FileInputStream(pathByIdStore);
            try {
                xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(stream);
                xmlReader.nextTag();
                xmlReader.nextTag();
                while (xmlReader.isStartElement()) {
                    block12: {
                        xmlReader.nextTag();
                        value1 = xmlReader.getElementText();
                        xmlReader.nextTag();
                        value2 = xmlReader.getElementText();
                        path = xmlReader.getLocalName().equals("path") != false ? value2 : value1;
                        xmlReader.nextTag();
                        if (this.migratedDeletedAttachment.contains(path)) break block12;
                        directory = new File(path);
                        if (directory.getCanonicalPath().startsWith(this.getStoreRootDirectory().getCanonicalPath())) ** GOTO lbl33
                        this.logger.warn("[{}] is the wrong path, trying to find the new location", (Object)directory);
                        directory = this.findNewPath(path);
                        if (directory == null) {
                            this.logger.warn("Could not find the deleted attachment in any other location");
                            this.migratedDeletedAttachment.add(path);
                        } else {
                            this.logger.info("Found deleted attachment on [{}]", (Object)directory);
lbl33:
                            // 2 sources

                            if (!directory.isDirectory()) {
                                this.logger.warn("[{}] is not a directory", (Object)directory);
                            } else {
                                documentDirectory = directory.getParentFile().getParentFile().getParentFile();
                                documentReference = this.getPre11DocumentReference(documentDirectory);
                                if (this.getXWikiContext().getWikiReference().equals((Object)documentReference.getWikiReference())) {
                                    this.storeDeletedAttachment(directory, documentReference, session);
                                    this.migratedDeletedAttachment.add(path);
                                }
                            }
                        }
                    }
                    xmlReader.nextTag();
                }
            }
            finally {
                stream.close();
            }
        }
    }

    private File findNewPath(String path) {
        Matcher matcher = STORAGE.matcher(path);
        if (matcher.find()) {
            String relative = path.substring(matcher.end());
            File newPath = new File(this.getStoreRootDirectory(), relative);
            if (newPath.exists()) {
                return newPath;
            }
        }
        return null;
    }

    private void storeDeletedAttachment(File directory, DocumentReference documentReference, Session session) throws ParserConfigurationException, SAXException, IOException, DataMigrationException {
        DeletedAttachment dbAttachment;
        this.logger.info("Storing attachment metadata [{}] in the database", (Object)directory);
        File file = new File(directory, "~DELETED_ATTACH_METADATA.xml");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(file);
        String filename = this.getElementText(doc, "filename", null);
        String deleter = this.getElementText(doc, "deleter", null);
        Date deleteDate = new Date(Long.valueOf(this.getElementText(doc, "datedeleted", null)));
        long docId = new XWikiDocument(documentReference).getId();
        Query selectQuery = session.createQuery("SELECT id FROM DeletedAttachment WHERE docId=:docId AND filename=:filename AND date=:date");
        selectQuery.setParameter("docId", (Object)docId);
        selectQuery.setParameter("filename", (Object)filename);
        selectQuery.setParameter("date", (Object)new Timestamp(deleteDate.getTime()));
        Long databaseId = (Long)selectQuery.uniqueResult();
        if (databaseId == null) {
            selectQuery.setParameter("date", (Object)new Timestamp(deleteDate.toInstant().getEpochSecond() * 1000L));
            databaseId = (Long)selectQuery.uniqueResult();
        }
        if (databaseId != null) {
            dbAttachment = new DeletedAttachment(docId, (String)this.serializer.serialize((EntityReference)documentReference, new Object[0]), filename, "file", deleter, deleteDate, null, databaseId.longValue());
            session.update((Object)dbAttachment);
        } else {
            dbAttachment = new DeletedAttachment(docId, (String)this.serializer.serialize((EntityReference)documentReference, new Object[0]), filename, "file", deleter, deleteDate, null);
            databaseId = (Long)session.save((Object)dbAttachment);
        }
        File newDirectory = new File(directory.getParentFile(), this.encode(dbAttachment.getFilename() + "-id" + databaseId));
        FileUtils.moveDirectory((File)directory, (File)newDirectory);
    }

    private String encode(String name) throws UnsupportedEncodingException {
        return URLEncoder.encode(name, "UTF-8");
    }

    private String getElementText(Document doc, String elementName, String def) {
        NodeList elements = doc.getElementsByTagName(elementName);
        if (elements.getLength() > 0) {
            return elements.item(0).getTextContent();
        }
        return def;
    }
}

