/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal.migration;

import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.store.filesystem.internal.migration.AbstractStoreTypeDataMigration;
import org.xwiki.store.filesystem.internal.migration.R1100000XWIKI15620DataMigration;

@Component
@Named(value="R1130040XWIKI16682")
@Singleton
public class R1130040XWIKI16682DataMigration
extends AbstractStoreTypeDataMigration {
    public R1130040XWIKI16682DataMigration() {
        super("XWikiAttachmentContent", "contentStore");
    }

    public String getDescription() {
        return "Fix attachments content store id missed because of a bug in migration R1100000XWIKI15620";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(1130040);
    }

    public void migrate() throws DataMigrationException {
        int version = this.getCurrentDBVersion().getVersion();
        if (version >= 1100000) {
            super.migrate();
        } else {
            this.logger.info("Skipping the migration (it's only needed when migrating from a version greater than 11.0)");
        }
    }

    @Override
    protected void doWork(Session session) {
        Query selectQuery = session.createQuery("SELECT attachment.id, attachment.filename, document.fullName FROM XWikiAttachment as attachment, XWikiDocument as document WHERE attachment.docId = document.id AND (attachment.contentStore is NULL)");
        List attachments = selectQuery.list();
        if (!attachments.isEmpty()) {
            try {
                this.setStore(attachments, session);
            }
            catch (IOException e) {
                throw new HibernateException("Failed to fix missed attachment", (Throwable)e);
            }
        }
    }

    private void setStore(List<Object[]> attachments, Session session) throws IOException {
        WikiReference wikiReference = this.getXWikiContext().getWikiReference();
        ArrayList<Long> fileAttachments = new ArrayList<Long>(attachments.size());
        for (Object[] attachment : attachments) {
            String fullName = (String)attachment[2];
            DocumentReference documentReference = this.resolver.resolve((Object)fullName, new Object[]{wikiReference});
            String filename = (String)attachment[1];
            if (StringUtils.isEmpty((CharSequence)filename)) {
                this.logger.warn("Unsupported attachment with empty string as name has been found on document [{}]. Ignoring it.", (Object)documentReference);
                continue;
            }
            Long id = (Long)attachment[0];
            AttachmentReference attachmentReference = new AttachmentReference(filename, documentReference);
            File attachmentDirectory = this.fstools.getAttachmentDir(attachmentReference);
            if (!attachmentDirectory.exists() || !R1100000XWIKI15620DataMigration.migrateAttachmentFiles(attachmentDirectory, attachmentReference.getName(), this.logger)) continue;
            fileAttachments.add(id);
        }
        this.setStore(session, fileAttachments, "file");
    }

    @Override
    protected boolean isFile(AttachmentReference attachmentReference) {
        return false;
    }
}

