/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal.migration;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.store.filesystem.internal.StoreFileUtils;
import org.xwiki.store.filesystem.internal.migration.AbstractFileStoreDataMigration;
import org.xwiki.store.internal.FileSystemStoreUtils;

@Component
@Named(value="R1100000XWIKI15620")
@Singleton
public class R1100000XWIKI15620DataMigration
extends AbstractFileStoreDataMigration {
    public static final int VERSION = 1100000;
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource configuration;

    public String getDescription() {
        return "Move the store to a new location. Change the path from URL encoding to hash based to support long references.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(1100000);
    }

    public void hibernateMigrate() throws XWikiException, DataMigrationException {
        this.migrateWiki(this.getXWikiContext().getWikiId());
    }

    private void cleanEmptyfolder(File directory) {
        try {
            Files.delete(directory.toPath());
        }
        catch (Exception e) {
            this.logger.warn("Failed to clean legacy folder [{}]: {}", (Object)directory, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void migrateWiki(String wikiId) throws DataMigrationException {
        File oldDirectory = this.getPre11WikiDir(wikiId);
        File newDirectory = this.fstools.getWikiDir(wikiId);
        if (oldDirectory.exists()) {
            try {
                this.logger.info("Moving wiki folder [{}] to new location [{}]", (Object)oldDirectory, (Object)newDirectory);
                this.moveDirectory(oldDirectory, newDirectory);
            }
            catch (IOException e) {
                throw new DataMigrationException("Failed to move wiki store to the new location", (Throwable)e);
            }
        }
        this.setStoreRootDirectory(this.fstools.getStoreRootDirectory());
        if (newDirectory.exists()) {
            try {
                this.migrate(newDirectory, true);
            }
            catch (IOException e) {
                throw new DataMigrationException("Failed to refactor filesystem store paths", (Throwable)e);
            }
        } else {
            this.logger.info("The wiki [{}] does not have any filesystem store", (Object)wikiId);
        }
    }

    private void migrate(File directory, boolean wiki) throws IOException, DataMigrationException {
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        for (File child : directory.listFiles()) {
            if (!child.isDirectory()) continue;
            if (!wiki && child.getName().equals("~this")) {
                this.migrateDocumentContent(child);
                continue;
            }
            this.migrate(child, false);
        }
        if (!wiki) {
            this.cleanEmptyfolder(directory);
        }
    }

    private void migrateDocumentContent(File oldDocumentContentDirectory) throws IOException, DataMigrationException {
        DocumentReference documentReference = this.getPre11DocumentReference(oldDocumentContentDirectory.getParentFile());
        File newDocumentContentDirectory = this.fstools.getDocumentContentDir(documentReference);
        this.logger.info("Moving document folder [{}] to new location [{}]", (Object)oldDocumentContentDirectory, (Object)newDocumentContentDirectory);
        this.moveDirectory(oldDocumentContentDirectory, newDocumentContentDirectory);
        this.migrateAttachments(newDocumentContentDirectory, documentReference);
        this.migrateDeletedAttachments(newDocumentContentDirectory, documentReference);
        this.migrateDocumentLocales(newDocumentContentDirectory);
    }

    private void migrateAttachments(File documentContentDirectory, DocumentReference documentReference) throws IOException {
        File attachmentsDirectory = new File(documentContentDirectory, "attachments");
        if (attachmentsDirectory.isDirectory()) {
            for (File oldAttachmentDirectory : attachmentsDirectory.listFiles()) {
                if (!oldAttachmentDirectory.isDirectory()) continue;
                AttachmentReference attachmentReference = new AttachmentReference(FileSystemStoreUtils.decode((String)oldAttachmentDirectory.getName()), documentReference);
                File newAttachmentDirectory = this.fstools.getAttachmentDir(attachmentReference);
                this.logger.info("Moving attachment folder [{}] to new location [{}]", (Object)oldAttachmentDirectory, (Object)newAttachmentDirectory);
                this.moveDirectory(oldAttachmentDirectory, newAttachmentDirectory);
                R1100000XWIKI15620DataMigration.migrateAttachmentFiles(newAttachmentDirectory, attachmentReference.getName(), this.logger);
            }
        }
    }

    public static boolean migrateAttachmentFiles(File attachmentDirectory, String attachmentName, Logger logger) throws IOException {
        boolean foundFile = false;
        int indexOfExtension = attachmentName.lastIndexOf(46);
        String baseAttachmentName = indexOfExtension >= 0 ? attachmentName.substring(0, indexOfExtension) : attachmentName;
        for (File file : attachmentDirectory.listFiles()) {
            String decodedFileName = FileSystemStoreUtils.decode((String)file.getName());
            if (!decodedFileName.startsWith(baseAttachmentName)) continue;
            String version = null;
            if (decodedFileName.length() > attachmentName.length()) {
                version = decodedFileName.substring(baseAttachmentName.length() + 2);
                if (indexOfExtension != -1) {
                    version = version.substring(0, version.length() - (attachmentName.length() - indexOfExtension));
                }
            }
            File newAttachmentFile = new File(attachmentDirectory, StoreFileUtils.getStoredFilename(attachmentName, version));
            logger.info("Moving attachment file [{}] to new location [{}]", (Object)file, (Object)newAttachmentFile);
            Files.move(file.toPath(), newAttachmentFile.toPath(), new CopyOption[0]);
            foundFile = true;
        }
        return foundFile;
    }

    private void migrateDeletedAttachments(File documentContentDirectory, DocumentReference documentReference) throws IOException {
        File deletedAttachmentsDirectory = new File(documentContentDirectory, "deleted-attachments");
        if (deletedAttachmentsDirectory.isDirectory()) {
            for (File oldDeletedAttachmentDirectory : deletedAttachmentsDirectory.listFiles()) {
                if (!oldDeletedAttachmentDirectory.isDirectory()) continue;
                String folderName = FileSystemStoreUtils.decode((String)oldDeletedAttachmentDirectory.getName());
                int index = folderName.lastIndexOf(45);
                String attachmentName = folderName.substring(0, index);
                long id = Long.parseLong(folderName.substring(index + 3));
                AttachmentReference attachmentReference = new AttachmentReference(attachmentName, documentReference);
                File newDeletedAttachmentDirectory = this.fstools.getDeletedAttachmentDir(attachmentReference, id);
                this.logger.info("Moving deleted attachment folder [{}] to new location [{}]", (Object)oldDeletedAttachmentDirectory, (Object)newDeletedAttachmentDirectory);
                this.moveDirectory(oldDeletedAttachmentDirectory, newDeletedAttachmentDirectory);
                R1100000XWIKI15620DataMigration.migrateAttachmentFiles(newDeletedAttachmentDirectory, attachmentReference.getName(), this.logger);
            }
        }
    }

    private void migrateDocumentLocales(File documentContentDirectory) throws DataMigrationException {
        File localesDirectory = new File(documentContentDirectory, "locales");
        if (localesDirectory.isDirectory()) {
            for (File localeDirectory : localesDirectory.listFiles()) {
                this.migrateDocumentLocale(documentContentDirectory, localeDirectory);
            }
        }
    }

    private Locale toLocale(File localeFile) {
        String localeString = FileSystemStoreUtils.decode((String)localeFile.getName());
        if (localeString.equals("~")) {
            return Locale.ROOT;
        }
        return LocaleUtils.toLocale((String)localeString);
    }

    private void migrateDocumentLocale(File documentContentDirectory, File localeDirectory) throws DataMigrationException {
        File localeThisDirectory = new File(localeDirectory, "~this");
        if (localeThisDirectory.isDirectory()) {
            Locale locale = this.toLocale(localeDirectory);
            File targetFolder = locale.equals(Locale.ROOT) ? documentContentDirectory : localeDirectory;
            this.moveFolderContent(localeThisDirectory, targetFolder);
            this.cleanEmptyfolder(localeThisDirectory);
            if (locale.equals(Locale.ROOT)) {
                this.cleanEmptyfolder(localeDirectory);
            }
        }
    }

    private void moveDirectory(File srcDir, File destDir) throws IOException {
        destDir.getParentFile().mkdirs();
        FileUtils.moveDirectory((File)srcDir, (File)destDir);
    }
}

