/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal.migration;

import com.xpn.xwiki.store.migration.DataMigrationException;
import java.io.File;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.store.filesystem.internal.migration.AbstractStoreTypeDataMigration;
import org.xwiki.store.internal.FileSystemStoreUtils;

public abstract class AbstractXWIKI15249DataMigration
extends AbstractStoreTypeDataMigration {
    @Inject
    @Named(value="file")
    protected EntityReferenceSerializer<String> fileEntitySerializer;

    public AbstractXWIKI15249DataMigration(String tableName, String fieldName) {
        super(tableName, fieldName);
    }

    public void migrate() throws DataMigrationException {
        int version = this.getCurrentDBVersion().getVersion();
        if (version < 1001000 && version < 1004001) {
            super.migrate();
        } else {
            this.logger.info("Skipping the migration (it's only needed when migrating from a version greater than 10.1)");
        }
    }

    protected File getDocumentContentDir(DocumentReference documentReference) {
        File documentDir = new File(this.getPre11StoreRootDirectory(), (String)this.fileEntitySerializer.serialize((EntityReference)documentReference, new Object[]{true}));
        File documentContentDir = new File(documentDir, "~this");
        Locale documentLocale = documentReference.getLocale();
        if (documentLocale != null) {
            File documentLocalesDir = new File(documentContentDir, "locales");
            File documentLocaleDir = new File(documentLocalesDir, documentLocale.equals(Locale.ROOT) ? "~" : documentLocale.toString());
            documentContentDir = new File(documentLocaleDir, "~this");
        }
        return documentContentDir;
    }

    protected File getAttachmentDir(AttachmentReference attachmentReference) {
        File docDir = this.getDocumentContentDir(attachmentReference.getDocumentReference());
        File attachmentsDir = new File(docDir, "attachments");
        return new File(attachmentsDir, FileSystemStoreUtils.encode((String)attachmentReference.getName(), (boolean)true));
    }
}

