/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal.migration;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.store.filesystem.internal.migration.AbstractStoreTypeDataMigration;

public abstract class AbstractXWIKI14697DataMigration
extends AbstractStoreTypeDataMigration {
    @Inject
    @Named(value="xwikicfg")
    protected ConfigurationSource configuration;
    @Inject
    @Named(value="path")
    protected EntityReferenceSerializer<String> pathSerializer;

    public AbstractXWIKI14697DataMigration(String tableName, String fieldName) {
        super(tableName, fieldName);
    }

    @Override
    protected void setOtherStore(List<Long> otherAttachments, Session session) {
        if (!otherAttachments.isEmpty()) {
            String configuredStore = (String)this.configuration.getProperty("xwiki.store.attachment.hint");
            if (configuredStore != null) {
                this.setStore(session, otherAttachments, configuredStore);
            } else {
                this.logger.warn("The attachments with the following ids have unknown store: {}", otherAttachments);
            }
        }
    }

    protected File getDocumentDir(DocumentReference docRef) {
        File path = new File(this.getPre11StoreRootDirectory(), (String)this.pathSerializer.serialize((EntityReference)docRef, new Object[]{false}));
        File docDir = new File(path, "~this");
        Locale docLocale = docRef.getLocale();
        if (docLocale != null) {
            File docLocalesDir = new File(docDir, "locales");
            File docLocaleDir = new File(docLocalesDir, docLocale.equals(Locale.ROOT) ? "~" : docLocale.toString());
            docDir = new File(docLocaleDir, "~this");
        }
        return docDir;
    }

    protected File getAttachmentDir(AttachmentReference attachmentReference) {
        File docDir = this.getDocumentDir(attachmentReference.getDocumentReference());
        File attachmentsDir = new File(docDir, "attachments");
        try {
            return new File(attachmentsDir, URLEncoder.encode(attachmentReference.getName(), "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new HibernateException("UTF8 is unknown", (Throwable)e);
        }
    }
}

