/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal;

import com.xpn.xwiki.doc.XWikiAttachment;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.locks.ReadWriteLock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.model.internal.reference.LocalUidStringEntityReferenceSerializer;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.store.filesystem.internal.AttachmentFileProvider;
import org.xwiki.store.filesystem.internal.DefaultAttachmentFileProvider;
import org.xwiki.store.filesystem.internal.DefaultDeletedAttachmentFileProvider;
import org.xwiki.store.filesystem.internal.DefaultDeletedDocumentContentFileProvider;
import org.xwiki.store.filesystem.internal.DeletedAttachmentFileProvider;
import org.xwiki.store.filesystem.internal.DeletedDocumentContentFileProvider;
import org.xwiki.store.filesystem.internal.FilesystemAttachmentsConfiguration;
import org.xwiki.store.filesystem.internal.StoreFileUtils;
import org.xwiki.store.locks.LockProvider;

@Component(roles={FilesystemStoreTools.class})
@Singleton
public class FilesystemStoreTools
implements Initializable {
    public static final String DOCUMENT_LOCALES_DIR_NAME = "locales";
    public static final String ATTACHMENTS_DIR_NAME = "attachments";
    public static final String DELETED_ATTACHMENTS_DIR_NAME = "deleted-attachments";
    public static final String DELETED_DOCUMENTS_DIR_NAME = "deleted-documents";
    private static final String BACKUP_FILE_SUFFIX = "~bak";
    private static final String TEMP_FILE_SUFFIX = "~tmp";
    @Inject
    private FilesystemAttachmentsConfiguration config;
    @Inject
    @Named(value="dummy")
    private LockProvider lockProvider;
    @Inject
    private Logger logger;
    @Inject
    private Environment environment;
    private File storeRootDirectory;

    public FilesystemStoreTools(File storageDir, LockProvider lockProvider) {
        this.storeRootDirectory = storageDir;
        this.lockProvider = lockProvider;
    }

    public FilesystemStoreTools() {
    }

    public void initialize() throws InitializationException {
        File fileStorageDirectory = this.config.getDirectory();
        if (fileStorageDirectory == null) {
            File storeDirectory = new File(this.environment.getPermanentDirectory(), "store");
            fileStorageDirectory = new File(storeDirectory, "file");
        }
        try {
            this.storeRootDirectory = fileStorageDirectory.getCanonicalFile();
        }
        catch (IOException e) {
            throw new InitializationException("Invalid permanent directory", (Throwable)e);
        }
        this.logger.info("Using filesystem store directory [{}]", (Object)this.storeRootDirectory);
        if (this.config.cleanOnStartup()) {
            File dir = this.storeRootDirectory;
            new Thread(() -> FilesystemStoreTools.deleteEmptyDirs(dir, 0)).start();
        }
    }

    private static boolean deleteEmptyDirs(File location, int depth) {
        if (location != null && location.exists() && location.isDirectory()) {
            File[] dirs = location.listFiles();
            boolean empty = true;
            for (int i = 0; i < dirs.length; ++i) {
                if (FilesystemStoreTools.deleteEmptyDirs(dirs[i], depth + 1)) continue;
                empty = false;
            }
            if (empty && depth != 0) {
                location.delete();
                return true;
            }
        }
        return false;
    }

    public File getBackupFile(File storageFile) {
        return new File(storageFile.getAbsolutePath() + BACKUP_FILE_SUFFIX + RandomStringUtils.secure().nextAlphanumeric(8));
    }

    public File getTempFile(File storageFile) {
        return new File(storageFile.getAbsolutePath() + TEMP_FILE_SUFFIX + RandomStringUtils.secure().nextAlphanumeric(8));
    }

    public DeletedAttachmentFileProvider getDeletedAttachmentFileProvider(AttachmentReference attachment, long index) {
        return new DefaultDeletedAttachmentFileProvider(this.getDeletedAttachmentDir(attachment, index), attachment.getName());
    }

    public DeletedDocumentContentFileProvider getDeletedDocumentFileProvider(DocumentReference documentReference, long index) {
        return new DefaultDeletedDocumentContentFileProvider(this.getDeletedDocumentContentDir(documentReference, index));
    }

    public File getStoreRootDirectory() {
        return this.storeRootDirectory;
    }

    public AttachmentFileProvider getAttachmentFileProvider(AttachmentReference attachmentReference) {
        return new DefaultAttachmentFileProvider(this.getAttachmentDir(attachmentReference), attachmentReference.getName());
    }

    public String getLinkContent(XWikiAttachment attachment) {
        AttachmentFileProvider provider = this.getAttachmentFileProvider(attachment.getReference());
        File defaultFile = provider.getAttachmentContentFile();
        File versionFile = provider.getAttachmentVersionContentFile(attachment.getVersion());
        return StoreFileUtils.getLinkContent(defaultFile.getParentFile(), versionFile);
    }

    public File getAttachmentDir(AttachmentReference attachmentReference) {
        File docDir = this.getDocumentContentDir(attachmentReference.getDocumentReference());
        File attachmentsDir = new File(docDir, ATTACHMENTS_DIR_NAME);
        return this.hashDirectory(attachmentsDir, attachmentReference.getName());
    }

    public File getDeletedAttachmentDir(AttachmentReference attachment, long index) {
        DocumentReference doc = attachment.getDocumentReference();
        File docDir = this.getDocumentContentDir(doc);
        File deletedAttachmentsDir = new File(docDir, DELETED_ATTACHMENTS_DIR_NAME);
        File deletedAttachmentDir = this.hashDirectory(deletedAttachmentsDir, attachment.getName());
        return new File(deletedAttachmentDir, String.valueOf(index));
    }

    public File getDeletedDocumentContentDir(DocumentReference documentReference, long index) {
        File docDir = this.getDocumentContentDir(documentReference);
        File deletedDocumentContentsDir = new File(docDir, DELETED_DOCUMENTS_DIR_NAME);
        return new File(deletedDocumentContentsDir, String.valueOf(index));
    }

    public File getWikiDir(String wikiId) {
        return new File(this.storeRootDirectory, wikiId);
    }

    private File hashDirectory(File parent, String name) {
        String md5 = DigestUtils.md5Hex((String)name);
        File documentDir1 = new File(parent, String.valueOf(md5.charAt(0)));
        File documentDir2 = new File(documentDir1, String.valueOf(md5.charAt(1)));
        return new File(documentDir2, String.valueOf(md5.substring(2)));
    }

    public File getDocumentContentDir(DocumentReference documentReference) {
        File wikiDir = this.getWikiDir(documentReference.getWikiReference().getName());
        String localKey = LocalUidStringEntityReferenceSerializer.INSTANCE.serialize((EntityReference)(documentReference.getLocale() != null ? new DocumentReference((EntityReference)documentReference, (Locale)null) : documentReference), new Object[0]);
        String md5 = DigestUtils.md5Hex((String)localKey);
        File documentDir1 = new File(wikiDir, String.valueOf(md5.charAt(0)));
        File documentDir2 = new File(documentDir1, String.valueOf(md5.charAt(1)));
        File documentDirFinal = new File(documentDir2, String.valueOf(md5.substring(2)));
        Locale documentLocale = documentReference.getLocale();
        if (documentLocale != null && !documentLocale.equals(Locale.ROOT)) {
            File documentLocalesDir = new File(documentDirFinal, DOCUMENT_LOCALES_DIR_NAME);
            documentDirFinal = new File(documentLocalesDir, documentLocale.toString());
        }
        return documentDirFinal;
    }

    public ReadWriteLock getLockForFile(File toLock) {
        return this.lockProvider.getLock((Object)toLock);
    }
}

