/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal;

import java.io.File;
import org.xwiki.store.filesystem.internal.AttachmentFileProvider;
import org.xwiki.store.filesystem.internal.StoreFileUtils;

public class DefaultAttachmentFileProvider
implements AttachmentFileProvider {
    private static final String ATTACH_ARCHIVE_META_FILENAME = "~METADATA.xml";
    private final File attachmentDir;
    private final String attachmentFileName;

    public DefaultAttachmentFileProvider(File attachmentDir, String fileName) {
        this.attachmentDir = attachmentDir;
        this.attachmentFileName = fileName;
    }

    protected File getAttachmentDir() {
        return this.attachmentDir;
    }

    protected String getAttachmentFileName() {
        return this.attachmentFileName;
    }

    @Override
    public File getAttachmentContentFile() {
        return new File(this.attachmentDir, StoreFileUtils.getStoredFilename(this.attachmentFileName, null));
    }

    @Override
    public File getAttachmentVersioningMetaFile() {
        return new File(this.attachmentDir, ATTACH_ARCHIVE_META_FILENAME);
    }

    @Override
    public File getAttachmentVersionContentFile(String versionName) {
        return new File(this.attachmentDir, StoreFileUtils.getStoredFilename(this.attachmentFileName, versionName));
    }
}

