/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.CharUtils;

public final class FileSystemStoreUtils {
    public static final String HINT = "file";

    private FileSystemStoreUtils() {
    }

    public static String encode(String name, boolean caseInsensitive) {
        StringBuilder builder = new StringBuilder(name.length() * 3);
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            boolean encode = false;
            switch (c) {
                case '\"': 
                case '%': 
                case '*': 
                case '+': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    encode = true;
                    break;
                }
                case ' ': {
                    if (i != 0 && i != name.length() - 1) break;
                    encode = true;
                    break;
                }
                case '.': {
                    if (i != 0 && i != name.length() - 1) break;
                    encode = true;
                    break;
                }
                default: {
                    if (CharUtils.isAscii((char)c) && (!caseInsensitive || !Character.isUpperCase(c))) break;
                    encode = true;
                }
            }
            if (encode) {
                FileSystemStoreUtils.encode(c, builder);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static void encode(char c, StringBuilder builder) {
        if (c == ' ') {
            builder.append("+");
        } else {
            byte[] ba = String.valueOf(c).getBytes(StandardCharsets.UTF_8);
            for (int j = 0; j < ba.length; ++j) {
                builder.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                ch = Character.toUpperCase(ch);
                builder.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                ch = Character.toUpperCase(ch);
                builder.append(ch);
            }
        }
    }

    public static String decode(String name) {
        try {
            return URLDecoder.decode(name, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not present on the system!", e);
        }
    }
}

