/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import org.xwiki.store.FileSerializer;
import org.xwiki.store.StartableTransactionRunnable;
import org.xwiki.store.StreamProvider;
import org.xwiki.store.StreamProviderFileSerializer;
import org.xwiki.store.TransactionRunnable;

public class FileSaveTransactionRunnable
extends StartableTransactionRunnable<TransactionRunnable> {
    private final File toSave;
    private final File tempFile;
    private final File backupFile;
    private final ReadWriteLock lock;
    private final FileSerializer serializer;
    private boolean runComplete;

    public FileSaveTransactionRunnable(File toSave, File tempFile, File backupFile, ReadWriteLock lock, StreamProvider provider) {
        this.toSave = toSave;
        this.tempFile = tempFile;
        this.backupFile = backupFile;
        this.lock = lock;
        this.serializer = new StreamProviderFileSerializer(provider);
    }

    public FileSaveTransactionRunnable(File toSave, File tempFile, File backupFile, ReadWriteLock lock, FileSerializer serializer) {
        this.toSave = toSave;
        this.tempFile = tempFile;
        this.backupFile = backupFile;
        this.lock = lock;
        this.serializer = serializer;
    }

    protected void onPreRun() throws IOException {
        this.lock.writeLock().lock();
        this.clearTempAndBackup();
    }

    protected void onRun() throws Exception {
        if (!this.toSave.getParentFile().exists() && !this.toSave.getParentFile().mkdirs()) {
            throw new IOException("Could not make directory tree to place file in. Do you have permission to write to [" + this.toSave.getAbsolutePath() + "] ?");
        }
        try {
            this.serializer.serialize(this.tempFile);
        }
        finally {
            this.runComplete = true;
        }
    }

    protected void onCommit() {
        if (this.toSave.exists()) {
            this.toSave.renameTo(this.backupFile);
        }
        this.tempFile.renameTo(this.toSave);
    }

    protected void onRollback() {
        if (this.runComplete) {
            if (this.tempFile.exists()) {
                this.onRollbackWithTempFile();
            } else {
                this.onRollbackNoTempFile();
            }
        }
    }

    protected void onComplete() throws IOException {
        try {
            this.clearTempAndBackup();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void onRollbackNoTempFile() {
        boolean isBackupFile = this.backupFile.exists();
        boolean isMainFile = this.toSave.exists();
        if (!isBackupFile && !isMainFile) {
            return;
        }
        if (!isBackupFile) {
            this.toSave.renameTo(this.tempFile);
            return;
        }
        if (!isMainFile) {
            this.backupFile.renameTo(this.toSave);
            return;
        }
        this.toSave.renameTo(this.tempFile);
        this.backupFile.renameTo(this.toSave);
    }

    private void onRollbackWithTempFile() {
        boolean isBackupFile = this.backupFile.exists();
        boolean isMainFile = this.toSave.exists();
        if (!isBackupFile) {
            return;
        }
        if (!isMainFile) {
            this.backupFile.renameTo(this.toSave);
            return;
        }
        throw new IllegalStateException("Tried to rollback the saving of file " + this.toSave.getAbsolutePath() + " and encountered a backup, a temp file, and a main file. Since any existing main file is renamed to a temp location and the content is saved in the backup location and then renamed to the main location, the existance of all 3 at once should never happen.");
    }

    private void clearTempAndBackup() throws IOException {
        if (this.tempFile.exists()) {
            this.tempFile.delete();
        }
        if (this.tempFile.exists()) {
            throw new IOException("Could not remove temporary file, cannot proceed.");
        }
        if (this.backupFile.exists()) {
            this.backupFile.delete();
        }
        if (this.backupFile.exists()) {
            throw new IOException("Could not remove backup file, cannot proceed.");
        }
    }
}

