/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.display;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.internal.display.AbstractBlockSupplierProvider;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.listener.Format;

@Component
@Singleton
public class BaseCollectionBlockSupplierProvider
extends AbstractBlockSupplierProvider<BaseCollection<? extends EntityReference>> {
    @Inject
    private Provider<XWikiContext> xWikiContextProvider;
    @Inject
    private ContextualLocalizationManager contextualLocalizationManager;

    public Supplier<Block> get(BaseCollection<? extends EntityReference> object, Object ... parameters) {
        List<Object> deprecatedPropertyNamesValues;
        XWikiContext context = (XWikiContext)this.xWikiContextProvider.get();
        BaseClass xClass = object.getXClass(context);
        List propertyNamesHintsValues = Arrays.stream(xClass.getProperties()).map(p -> (PropertyClass)p).map(p -> {
            if (p instanceof TextAreaClass) {
                return new AbstractBlockSupplierProvider.PropertyDisplay(p.getTranslatedPrettyName(context), p.getHint(), object.getStringValue(p.getName()), false);
            }
            return new AbstractBlockSupplierProvider.PropertyDisplay(p.getTranslatedPrettyName(context), p.getHint(), p.displayView(p.getName(), object, context), true);
        }).collect(Collectors.toList());
        if (object instanceof BaseObject) {
            BaseObject baseObject = (BaseObject)object;
            deprecatedPropertyNamesValues = xClass.getDeprecatedObjectProperties(baseObject).stream().map(p -> new AbstractBlockSupplierProvider.PropertyDisplay(p.getName(), null, p.getValue().toString(), false)).collect(Collectors.toList());
        } else {
            deprecatedPropertyNamesValues = List.of();
        }
        Translation removedPropertiesMessage = this.contextualLocalizationManager.getTranslation("core.editors.object.removeDeprecatedProperties.info");
        return () -> {
            Block propertiesBlock = this.renderProperties(propertyNamesHintsValues);
            CompositeBlock result = new CompositeBlock(List.of(propertiesBlock));
            if (!deprecatedPropertyNamesValues.isEmpty()) {
                GroupBlock deprecatedPropertiesBlock = new GroupBlock(Map.of("class", "box warningmessage deprecatedProperties"));
                if (removedPropertiesMessage != null) {
                    deprecatedPropertiesBlock.addChild((Block)new FormatBlock(List.of(removedPropertiesMessage.render(new Object[]{xClass.getPrettyName()})), Format.BOLD));
                }
                deprecatedPropertiesBlock.addChild(this.renderProperties(deprecatedPropertyNamesValues));
                result.addChild((Block)deprecatedPropertiesBlock);
            }
            return result;
        };
    }
}

