/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.display;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.platform.security.requiredrights.display.BlockSupplierProvider;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.DefinitionDescriptionBlock;
import org.xwiki.rendering.block.DefinitionListBlock;
import org.xwiki.rendering.block.DefinitionTermBlock;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.ParserUtils;

public abstract class AbstractBlockSupplierProvider<T>
implements BlockSupplierProvider<T> {
    protected static final String CLASS_ATTRIBUTE = "class";
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;
    private final ParserUtils parserUtils = new ParserUtils();

    protected Block renderProperties(List<PropertyDisplay> propertyNamesHintsValues) {
        List propertyBlocks = propertyNamesHintsValues.stream().flatMap(this::renderProperty).collect(Collectors.toList());
        return new DefinitionListBlock(propertyBlocks, Map.of(CLASS_ATTRIBUTE, "xform"));
    }

    protected Block getCodeBlock(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return new GroupBlock(List.of(this.getStringBlock(value)), Map.of(CLASS_ATTRIBUTE, "code box"));
        }
        return new CompositeBlock();
    }

    private Stream<Block> renderProperty(PropertyDisplay nameHintValue) {
        DefinitionTermBlock nameBlock;
        Block nameStringBlock = this.getStringBlock(nameHintValue.getName());
        if (StringUtils.isNotBlank((CharSequence)nameHintValue.getHint())) {
            FormatBlock hintBlock = new FormatBlock(List.of(this.getStringBlock(nameHintValue.getHint())), Format.NONE, Map.of(CLASS_ATTRIBUTE, "xHint"));
            nameBlock = new DefinitionTermBlock(List.of(nameStringBlock, hintBlock));
        } else {
            nameBlock = new DefinitionTermBlock(List.of(nameStringBlock));
        }
        DefinitionDescriptionBlock valueBlock = nameHintValue.isHtmlValue() ? new DefinitionDescriptionBlock(List.of(new RawBlock(nameHintValue.getValue(), Syntax.HTML_5_0))) : new DefinitionDescriptionBlock(List.of(this.getCodeBlock(nameHintValue.getValue())));
        return Stream.of(nameBlock, valueBlock);
    }

    protected Block getStringBlock(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            try {
                return this.parserUtils.convertToInline((Block)this.plainTextParser.parse((Reader)new StringReader(value)), false);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new CompositeBlock();
    }

    protected static class PropertyDisplay {
        private final String name;
        private final String hint;
        private final String value;
        private final boolean htmlValue;

        PropertyDisplay(String name, String hint, String value, boolean htmlValue) {
            this.name = name;
            this.hint = hint;
            this.value = value;
            this.htmlValue = htmlValue;
        }

        public String getName() {
            return this.name;
        }

        public String getHint() {
            return this.hint;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isHtmlValue() {
            return this.htmlValue;
        }
    }
}

