/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import com.xpn.xwiki.doc.XWikiDocument;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.bridge.internal.DocumentContextExecutor;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.display.BlockSupplierProvider;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.velocity.internal.util.VelocityDetector;

@Component
@Singleton
@Named(value="content")
public class XWikiDocumentContentRequiredRightAnalyzer
implements RequiredRightAnalyzer<XWikiDocument> {
    @Inject
    private DocumentContextExecutor documentContextExecutor;
    @Inject
    @Named(value="translation")
    private BlockSupplierProvider<String> translationMessageSupplierProvider;
    @Inject
    private RequiredRightAnalyzer<XDOM> xdomRequiredRightAnalyzer;
    @Inject
    private VelocityDetector velocityDetector;

    public List<RequiredRightAnalysisResult> analyze(XWikiDocument document) throws RequiredRightsException {
        try {
            return (List)this.documentContextExecutor.call(() -> {
                XDOM xdom;
                ArrayList<RequiredRightAnalysisResult> result = new ArrayList<RequiredRightAnalysisResult>();
                if (this.velocityDetector.containsVelocityScript(document.getTitle())) {
                    result.add(new RequiredRightAnalysisResult((EntityReference)document.getDocumentReferenceWithLocale(), this.translationMessageSupplierProvider.get((Object)"security.requiredrights.title", new Object[0]), this.translationMessageSupplierProvider.get((Object)"security.requiredrights.title.description", new Object[]{document.getTitle()}), List.of(RequiredRight.MAYBE_SCRIPT, RequiredRight.MAYBE_PROGRAM)));
                }
                if ((xdom = document.getXDOM()) != null && xdom.getMetaData() != null) {
                    xdom.getMetaData().addMetaData("entityReference", (Object)document.getDocumentReferenceWithLocale());
                }
                result.addAll(this.xdomRequiredRightAnalyzer.analyze((Object)xdom));
                return result;
            }, (DocumentModelBridge)document);
        }
        catch (Exception e) {
            throw new RequiredRightsException("Error analyzing document title and content.", (Throwable)e);
        }
    }
}

