/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import com.xpn.xwiki.objects.classes.BaseClass;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.ClassPropertyReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.display.BlockSupplierProvider;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ContentParser;

@Component(roles={XClassWikiContentAnalyzer.class})
@Singleton
public class XClassWikiContentAnalyzer {
    @Inject
    private ContentParser contentParser;
    @Inject
    private RequiredRightAnalyzer<XDOM> xdomRequiredRightAnalyzer;
    @Inject
    @Named(value="translation")
    private BlockSupplierProvider<String> translationMessageSupplierProvider;
    @Inject
    @Named(value="stringCode")
    private BlockSupplierProvider<String> stringCodeBlockSupplierProvider;

    public List<RequiredRightAnalysisResult> analyzeWikiContent(BaseClass xClass, String script, ClassPropertyReference reference) {
        try {
            XDOM scriptXDOM = this.contentParser.parse(script, xClass.getOwnerDocument().getSyntax(), (EntityReference)xClass.getDocumentReference());
            scriptXDOM.getMetaData().addMetaData("entityReference", (Object)reference);
            return this.xdomRequiredRightAnalyzer.analyze((Object)scriptXDOM);
        }
        catch (Exception e) {
            return List.of(new RequiredRightAnalysisResult((EntityReference)reference, this.translationMessageSupplierProvider.get((Object)"security.requiredrights.class.errorAnalyzingWiki", new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)e)}), this.stringCodeBlockSupplierProvider.get((Object)script, new Object[0]), List.of(RequiredRight.MAYBE_PROGRAM)));
        }
    }
}

