/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;

@Named(value="withTranslations")
@Component
@Singleton
public class WithTranslationsDocumentRequiredRightAnalyzer
implements RequiredRightAnalyzer<DocumentReference> {
    @Inject
    private RequiredRightAnalyzer<XWikiDocument> requiredRightAnalyzer;
    @Inject
    @Named(value="content")
    private RequiredRightAnalyzer<XWikiDocument> contentAnalyzer;
    @Inject
    private Provider<XWikiContext> xWikiContextProvider;

    public List<RequiredRightAnalysisResult> analyze(DocumentReference documentReference) throws RequiredRightsException {
        XWikiDocument document;
        XWikiContext context = (XWikiContext)this.xWikiContextProvider.get();
        try {
            document = context.getWiki().getDocument(documentReference.withoutLocale(), context);
        }
        catch (XWikiException e) {
            throw new RequiredRightsException("Failed to load document", (Throwable)e);
        }
        ArrayList<RequiredRightAnalysisResult> results = new ArrayList<RequiredRightAnalysisResult>(this.requiredRightAnalyzer.analyze((Object)document));
        try {
            List translationLocales = document.getTranslationLocales(context);
            for (Locale locale : translationLocales) {
                XWikiDocument translation = document.getTranslatedDocument(locale, context);
                results.addAll(this.contentAnalyzer.analyze((Object)translation));
            }
        }
        catch (XWikiException e) {
            throw new RequiredRightsException("Failed to load translations", (Throwable)e);
        }
        return results;
    }
}

