/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.display.BlockSupplierProvider;
import org.xwiki.platform.security.requiredrights.internal.analyzer.AbstractMacroBlockRequiredRightAnalyzer;
import org.xwiki.properties.BeanManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.script.MacroPermissionPolicy;
import org.xwiki.rendering.macro.script.PrivilegedScriptMacro;
import org.xwiki.rendering.macro.script.ScriptMacroParameters;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
@Named(value="script")
public class ScriptMacroAnalyzer
extends AbstractMacroBlockRequiredRightAnalyzer
implements RequiredRightAnalyzer<MacroBlock> {
    public static final String ID = "script";
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private BeanManager beanManager;
    @Inject
    @Named(value="translation")
    private BlockSupplierProvider<String> translationMessageSupplierProvider;
    @Inject
    private BlockSupplierProvider<MacroBlock> macroDisplayerProvider;

    public List<RequiredRightAnalysisResult> analyze(MacroBlock macroBlock) {
        Right requiredRight;
        block3: {
            requiredRight = Right.PROGRAM;
            Macro<?> macro = this.getMacro(macroBlock);
            try {
                Object macroParameters = macro.getDescriptor().getParametersBeanClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.beanManager.populate(macroParameters, macroBlock.getParameters());
                if (macroParameters instanceof ScriptMacroParameters) {
                    MacroPermissionPolicy mpp = (MacroPermissionPolicy)((ComponentManager)this.componentManagerProvider.get()).getInstance(MacroPermissionPolicy.class, macroBlock.getId());
                    requiredRight = mpp.getRequiredRight((ScriptMacroParameters)macroParameters);
                }
            }
            catch (Exception ex) {
                if (macro instanceof PrivilegedScriptMacro) break block3;
                requiredRight = Right.SCRIPT;
            }
        }
        return this.generateResult(macroBlock, macroBlock.getId(), requiredRight);
    }

    private List<RequiredRightAnalysisResult> generateResult(MacroBlock macroBlock, String macroId, Right right) {
        List<RequiredRight> requiredRights;
        String messageKey;
        EntityReference reference = this.extractSourceReference((Block)macroBlock);
        if (right == Right.PROGRAM) {
            messageKey = "security.requiredrights.macro.script.program";
            requiredRights = List.of(RequiredRight.PROGRAM);
        } else {
            messageKey = "security.requiredrights.macro.script.script";
            requiredRights = List.of(new RequiredRight(right, EntityType.DOCUMENT, false), RequiredRight.MAYBE_PROGRAM);
        }
        return List.of(new RequiredRightAnalysisResult(reference, this.translationMessageSupplierProvider.get((Object)messageKey, new Object[]{macroId}), this.macroDisplayerProvider.get((Object)macroBlock, new Object[0]), requiredRights));
    }
}

