/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.display.BlockSupplierProvider;
import org.xwiki.velocity.internal.util.VelocityDetector;

@Component
@Singleton
@Named(value="XWiki.PDFClass")
public class PDFClassObjectRequiredRightsAnalyzer
implements RequiredRightAnalyzer<BaseObject> {
    @Inject
    private VelocityDetector velocityDetector;
    @Inject
    @Named(value="translation")
    private BlockSupplierProvider<String> translationMessageSupplierProvider;
    @Inject
    @Named(value="stringCode")
    private BlockSupplierProvider<String> stringCodeBlockSupplierProvider;

    public List<RequiredRightAnalysisResult> analyze(BaseObject object) throws RequiredRightsException {
        ArrayList<RequiredRightAnalysisResult> results = new ArrayList<RequiredRightAnalysisResult>();
        for (String propertyName : object.getPropertyList()) {
            try {
                BaseProperty field = (BaseProperty)object.get(propertyName);
                String value = (String)field.getValue();
                if (!this.velocityDetector.containsVelocityScript(value)) continue;
                results.add(new RequiredRightAnalysisResult(field.getReference(), this.translationMessageSupplierProvider.get((Object)"security.requiredrights.object.pdfClass", new Object[]{propertyName}), this.stringCodeBlockSupplierProvider.get((Object)value, new Object[0]), RequiredRight.SCRIPT_AND_MAYBE_PROGRAM));
            }
            catch (XWikiException e) {
                throw new RequiredRightsException(String.format("Failed to get the property [%s] to analyze", propertyName), (Throwable)e);
            }
        }
        return results;
    }
}

