/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseStringProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.display.BlockSupplierProvider;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ContentParser;
import org.xwiki.rendering.parser.MissingParserException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.velocity.internal.util.VelocityDetector;

@Component(roles={ObjectPropertyRequiredRightAnalyzer.class})
@Singleton
public class ObjectPropertyRequiredRightAnalyzer {
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private VelocityDetector velocityDetector;
    @Inject
    @Named(value="translation")
    private BlockSupplierProvider<String> translationMessageSupplierProvider;
    @Inject
    @Named(value="stringCode")
    private BlockSupplierProvider<String> stringCodeBlockSupplierProvider;
    @Inject
    private BlockSupplierProvider<BaseObject> objectBlockSupplierProvider;
    @Inject
    private RequiredRightAnalyzer<XDOM> xdomRequiredRightAnalyzer;
    @Inject
    private ContentParser contentParser;

    public RequiredRightAnalysisResult createObjectResult(BaseObject object, RequiredRight right, String translationMessage, Object ... messageParameters) {
        return new RequiredRightAnalysisResult(object.getReference(), this.translationMessageSupplierProvider.get((Object)translationMessage, messageParameters), this.objectBlockSupplierProvider.get((Object)object, new Object[0]), List.of(right));
    }

    public List<RequiredRightAnalysisResult> analyzeAllPropertiesAndAddObjectResult(BaseObject object, RequiredRight right, String translationMessage, Object ... messageParameters) throws RequiredRightsException {
        List<RequiredRightAnalysisResult> results = this.analyzeAllProperties(object);
        results.add(this.createObjectResult(object, right, translationMessage, messageParameters));
        return results;
    }

    public List<RequiredRightAnalysisResult> analyzeAllProperties(BaseObject object) throws RequiredRightsException {
        BaseClass xClass = object.getXClass((XWikiContext)this.contextProvider.get());
        ArrayList<RequiredRightAnalysisResult> results = new ArrayList<RequiredRightAnalysisResult>();
        for (String propertyName : object.getPropertyList()) {
            results.addAll(this.analyzeProperty(object, propertyName, xClass));
        }
        return results;
    }

    public List<RequiredRightAnalysisResult> analyzeProperty(BaseObject object, String propertyName, BaseClass xClass) throws RequiredRightsException {
        PropertyInterface property = xClass.getField(propertyName);
        if (property instanceof TextAreaClass) {
            TextAreaClass textAreaClass = (TextAreaClass)property;
            return this.analyzeTextAreaProperty(object, propertyName, textAreaClass);
        }
        return List.of();
    }

    private List<RequiredRightAnalysisResult> analyzeTextAreaProperty(BaseObject object, String propertyName, TextAreaClass textAreaClass) throws RequiredRightsException {
        BaseStringProperty baseStringProperty;
        String value;
        String contentTypeString = textAreaClass.getContentType();
        TextAreaClass.ContentType contentType = TextAreaClass.ContentType.getByValue((String)contentTypeString);
        if (contentType == null) {
            contentType = TextAreaClass.ContentType.WIKI_TEXT;
        }
        PropertyInterface field = object.getField(propertyName);
        List<RequiredRightAnalysisResult> result = List.of();
        if (!textAreaClass.isRestricted() && field instanceof BaseStringProperty && StringUtils.isNotBlank((CharSequence)(value = (baseStringProperty = (BaseStringProperty)field).getValue()))) {
            switch (contentType) {
                case VELOCITY_CODE: {
                    result = this.analyzeVelocityScriptValue(value, field.getReference(), "security.requiredrights.object.velocityCodeTextArea");
                    break;
                }
                case VELOCITYWIKI: {
                    result = this.analyzeVelocityScriptValue(value, field.getReference(), "security.requiredrights.object.velocityWikiTextArea");
                    if (!result.isEmpty()) break;
                    result = this.analyzeWikiContent(object, value, field.getReference());
                    break;
                }
                case PURE_TEXT: {
                    break;
                }
                default: {
                    result = this.analyzeWikiContent(object, value, field.getReference());
                }
            }
        }
        return result;
    }

    public List<RequiredRightAnalysisResult> analyzeVelocityScriptValue(String value, EntityReference reference, String translationMessage) {
        List<RequiredRightAnalysisResult> result = this.velocityDetector.containsVelocityScript(value) ? List.of(new RequiredRightAnalysisResult(reference, this.translationMessageSupplierProvider.get((Object)translationMessage, new Object[0]), this.stringCodeBlockSupplierProvider.get((Object)value, new Object[0]), RequiredRight.SCRIPT_AND_MAYBE_PROGRAM)) : List.of();
        return result;
    }

    public List<RequiredRightAnalysisResult> analyzeWikiContent(BaseObject object, String value, EntityReference reference) throws RequiredRightsException {
        try {
            XDOM parsedContent = this.contentParser.parse(value, object.getOwnerDocument().getSyntax(), (EntityReference)object.getDocumentReference());
            parsedContent.getMetaData().addMetaData("entityReference", (Object)reference);
            return this.xdomRequiredRightAnalyzer.analyze((Object)parsedContent);
        }
        catch (MissingParserException | ParseException e) {
            throw new RequiredRightsException("Failed to parse content of object property", e);
        }
    }
}

