/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import com.xpn.xwiki.objects.BaseObject;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.internal.analyzer.ObjectPropertyRequiredRightAnalyzer;

@Component
@Singleton
public class DefaultObjectRequiredRightAnalyzer
implements RequiredRightAnalyzer<BaseObject> {
    @Inject
    private ObjectPropertyRequiredRightAnalyzer objectPropertyRequiredRightAnalyzer;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;
    @Inject
    private Provider<ComponentManager> componentManagerProvider;

    public List<RequiredRightAnalysisResult> analyze(BaseObject object) throws RequiredRightsException {
        if (object == null) {
            return List.of();
        }
        try {
            return this.analyzeWithException(object);
        }
        catch (Exception e) {
            return List.of(this.objectPropertyRequiredRightAnalyzer.createObjectResult(object, RequiredRight.MAYBE_PROGRAM, "security.requiredrights.object.error", ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
    }

    private List<RequiredRightAnalysisResult> analyzeWithException(BaseObject object) throws RequiredRightsException {
        EntityReference xClassReference = object.getRelativeXClassReference();
        String className = (String)this.compactEntityReferenceSerializer.serialize(xClassReference, new Object[0]);
        try {
            RequiredRightAnalyzer analyzer = (RequiredRightAnalyzer)((ComponentManager)this.componentManagerProvider.get()).getInstance((Type)new DefaultParameterizedType(null, RequiredRightAnalyzer.class, new Type[]{BaseObject.class}), className);
            return analyzer.analyze((Object)object);
        }
        catch (ComponentLookupException e) {
            return this.objectPropertyRequiredRightAnalyzer.analyzeAllProperties(object);
        }
    }
}

