/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.platform.security.requiredrights.MacroRequiredRight;
import org.xwiki.platform.security.requiredrights.MacroRequiredRightReporter;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.internal.analyzer.AbstractMacroBlockRequiredRightAnalyzer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.syntax.Syntax;

@Component(roles={DefaultMacroRequiredRightReporter.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultMacroRequiredRightReporter
extends AbstractMacroBlockRequiredRightAnalyzer
implements MacroRequiredRightReporter {
    private final List<RequiredRightAnalysisResult> results = new ArrayList<RequiredRightAnalysisResult>();

    public void report(MacroBlock macroBlock, List<MacroRequiredRight> requiredRights, String summaryTranslationKey, Object ... translationParameters) {
        this.results.add(new RequiredRightAnalysisResult(this.extractSourceReference((Block)macroBlock), this.translationBlockSupplierProvider.get((Object)summaryTranslationKey, translationParameters), this.macroBlockBlockSupplierProvider.get((Object)macroBlock, new Object[0]), requiredRights.stream().map(this::translateMacroRequiredRight).collect(Collectors.toList())));
    }

    private RequiredRight translateMacroRequiredRight(MacroRequiredRight macroRequiredRight) {
        return switch (macroRequiredRight) {
            case MacroRequiredRight.PROGRAM -> RequiredRight.PROGRAM;
            case MacroRequiredRight.MAYBE_PROGRAM -> RequiredRight.MAYBE_PROGRAM;
            case MacroRequiredRight.SCRIPT -> RequiredRight.SCRIPT;
            case MacroRequiredRight.MAYBE_SCRIPT -> RequiredRight.MAYBE_SCRIPT;
            default -> null;
        };
    }

    public void analyzeContent(MacroBlock macroBlock, String content) {
        this.analyzeContent(macroBlock, content, null);
    }

    public void analyzeContent(MacroBlock macroBlock, String content, Syntax syntax) {
        if (StringUtils.isNotBlank((CharSequence)content)) {
            try {
                this.results.addAll(this.analyzeMacroContent(macroBlock, content, syntax));
            }
            catch (RequiredRightsException e) {
                this.results.add(this.reportAnalysisError(macroBlock, (Exception)((Object)e)));
            }
        }
    }

    public List<RequiredRightAnalysisResult> getResults() {
        return this.results;
    }
}

