/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.platform.security.requiredrights.MacroParameterRequiredRightsAnalyzer;
import org.xwiki.platform.security.requiredrights.MacroRequiredRight;
import org.xwiki.platform.security.requiredrights.MacroRequiredRightReporter;
import org.xwiki.platform.security.requiredrights.MacroRequiredRightsAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.internal.analyzer.AbstractMacroBlockRequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.internal.analyzer.DefaultMacroRequiredRightReporter;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;
import org.xwiki.rendering.macro.script.ScriptMacro;

@Component
@Singleton
public class DefaultMacroBlockRequiredRightAnalyzer
extends AbstractMacroBlockRequiredRightAnalyzer
implements RequiredRightAnalyzer<MacroBlock> {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    @Named(value="script")
    private RequiredRightAnalyzer<MacroBlock> scriptMacroAnalyzer;
    @Inject
    private Logger logger;
    @Inject
    private Provider<DefaultMacroRequiredRightReporter> macroRequiredRightReporterProvider;

    public List<RequiredRightAnalysisResult> analyze(MacroBlock macroBlock) {
        List<RequiredRightAnalysisResult> result;
        try {
            result = this.analyzeWithExceptions(macroBlock);
        }
        catch (Exception e) {
            result = List.of(this.reportAnalysisError(macroBlock, e));
        }
        return result;
    }

    private List<RequiredRightAnalysisResult> analyzeWithExceptions(MacroBlock macroBlock) throws RequiredRightsException {
        List<RequiredRightAnalysisResult> result;
        Optional<RequiredRightAnalyzer<MacroBlock>> specificAnalyzer = this.getMacroBlockRequiredRightAnalyzer(macroBlock);
        if (specificAnalyzer.isPresent()) {
            result = specificAnalyzer.get().analyze((Object)macroBlock);
        } else {
            Optional<MacroRequiredRightsAnalyzer> macroAnalyzer = this.getMacroAnalyzer(macroBlock.getId());
            if (macroAnalyzer.isPresent()) {
                DefaultMacroRequiredRightReporter reporter = (DefaultMacroRequiredRightReporter)this.macroRequiredRightReporterProvider.get();
                macroAnalyzer.get().analyze(macroBlock, (MacroRequiredRightReporter)reporter);
                result = reporter.getResults();
            } else {
                Macro<?> macro = this.getMacro(macroBlock);
                if (macro instanceof ScriptMacro) {
                    result = this.scriptMacroAnalyzer.analyze((Object)macroBlock);
                } else if (macro != null) {
                    result = new ArrayList<RequiredRightAnalysisResult>(this.maybeAnalyzeMacroContent(macroBlock, macro));
                    result.addAll(this.maybeAnalyzeParameters(macroBlock, macro));
                } else {
                    result = List.of();
                }
            }
        }
        return result;
    }

    private List<RequiredRightAnalysisResult> maybeAnalyzeParameters(MacroBlock macroBlock, Macro<?> macro) {
        Map parameterDescriptorMap = macro.getDescriptor().getParameterDescriptorMap();
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        DefaultMacroRequiredRightReporter reporter = (DefaultMacroRequiredRightReporter)this.macroRequiredRightReporterProvider.get();
        for (Map.Entry<String, String> entry : macroBlock.getParameters().entrySet()) {
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptorMap.get(((String)entry.getKey()).toLowerCase());
            if (parameterDescriptor == null || entry.getValue() == null) continue;
            if (parameterDescriptor.getParameterType() != null) {
                DefaultMacroBlockRequiredRightAnalyzer.analyzeMacroParameter(macroBlock, entry, parameterDescriptor, componentManager, reporter, parameterDescriptor.getParameterType());
            }
            if (Objects.equals(parameterDescriptor.getDisplayType(), parameterDescriptor.getParameterType()) || parameterDescriptor.getDisplayType() == null) continue;
            DefaultMacroBlockRequiredRightAnalyzer.analyzeMacroParameter(macroBlock, entry, parameterDescriptor, componentManager, reporter, parameterDescriptor.getDisplayType());
        }
        return reporter.getResults();
    }

    private static void analyzeMacroParameter(MacroBlock macroBlock, Map.Entry<String, String> parameter, ParameterDescriptor parameterDescriptor, ComponentManager componentManager, DefaultMacroRequiredRightReporter reporter, Type parameterType) {
        try {
            DefaultParameterizedType componentType = new DefaultParameterizedType(null, MacroParameterRequiredRightsAnalyzer.class, new Type[]{parameterType});
            if (componentManager.hasComponent((Type)componentType)) {
                MacroParameterRequiredRightsAnalyzer analyzer = (MacroParameterRequiredRightsAnalyzer)componentManager.getInstance((Type)componentType);
                analyzer.analyze(macroBlock, parameterDescriptor, parameter.getValue(), (MacroRequiredRightReporter)reporter);
            }
        }
        catch (Exception e) {
            reporter.report(macroBlock, List.of(MacroRequiredRight.MAYBE_PROGRAM), "security.requiredrights.macro.analyzer.parameterError", parameterDescriptor.getId(), macroBlock.getId(), ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private List<RequiredRightAnalysisResult> maybeAnalyzeMacroContent(MacroBlock macroBlock, Macro<?> macro) throws RequiredRightsException {
        ContentDescriptor contentDescriptor = macro.getDescriptor().getContentDescriptor();
        if (contentDescriptor != null && Block.LIST_BLOCK_TYPE.equals(contentDescriptor.getType())) {
            return this.analyzeMacroContent(macroBlock, macroBlock.getContent());
        }
        return List.of();
    }

    private Optional<RequiredRightAnalyzer<MacroBlock>> getMacroBlockRequiredRightAnalyzer(MacroBlock macroBlock) {
        String macroId = macroBlock.getId();
        DefaultParameterizedType roleType = new DefaultParameterizedType(null, RequiredRightAnalyzer.class, new Type[]{MacroBlock.class});
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        try {
            if (!"default".equals(macroId) && componentManager.hasComponent((Type)roleType, macroId)) {
                return Optional.of((RequiredRightAnalyzer)componentManager.getInstance((Type)roleType, macroId));
            }
        }
        catch (ComponentLookupException e) {
            this.logger.warn("The macro block required rights analyzer for macro [{}] failed to be initialized, root cause: [{}]", (Object)macroId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            this.logger.debug("Full exception trace: ", (Throwable)e);
        }
        return Optional.empty();
    }

    private Optional<MacroRequiredRightsAnalyzer> getMacroAnalyzer(String id) {
        try {
            return Optional.of((MacroRequiredRightsAnalyzer)((ComponentManager)this.componentManagerProvider.get()).getInstance(MacroRequiredRightsAnalyzer.class, id));
        }
        catch (ComponentLookupException e) {
            return Optional.empty();
        }
    }
}

