/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import com.xpn.xwiki.objects.classes.ComputedFieldClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.ClassPropertyReference;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.internal.analyzer.XClassWikiContentAnalyzer;

@Component
@Singleton
public class ComputedFieldClassRequiredRightAnalyzer
implements RequiredRightAnalyzer<ComputedFieldClass> {
    @Inject
    private XClassWikiContentAnalyzer wikiContentAnalyzer;
    @Inject
    private RequiredRightAnalyzer<PropertyClass> propertyClassRequiredRightAnalyzer;

    public List<RequiredRightAnalysisResult> analyze(ComputedFieldClass computedFieldClass) throws RequiredRightsException {
        ArrayList<RequiredRightAnalysisResult> results = new ArrayList<RequiredRightAnalysisResult>(this.propertyClassRequiredRightAnalyzer.analyze((Object)computedFieldClass));
        if (computedFieldClass != null && StringUtils.isNotBlank((CharSequence)computedFieldClass.getScript())) {
            results.addAll(this.wikiContentAnalyzer.analyzeWikiContent(computedFieldClass.getOwnerDocument().getXClass(), computedFieldClass.getScript(), (ClassPropertyReference)computedFieldClass.getReference()));
        }
        return results;
    }
}

