/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.display.BlockSupplierProvider;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.RenderingContext;

public abstract class AbstractMacroBlockRequiredRightAnalyzer {
    @Inject
    protected RequiredRightAnalyzer<XDOM> xdomRequiredRightAnalyzer;
    @Inject
    protected MacroContentParser macroContentParser;
    @Inject
    protected BlockSupplierProvider<MacroBlock> macroBlockBlockSupplierProvider;
    @Inject
    @Named(value="translation")
    protected BlockSupplierProvider<String> translationBlockSupplierProvider;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private MacroManager macroManager;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;

    private MacroTransformationContext getTransformationContext(MacroBlock macroBlock) {
        MacroTransformationContext macroTransformationContext = new MacroTransformationContext();
        macroTransformationContext.setId("RequiredRightAnalyzer_" + macroBlock.getId());
        macroTransformationContext.setCurrentMacroBlock(macroBlock);
        macroTransformationContext.setSyntax(this.renderingContext.getDefaultSyntax());
        macroTransformationContext.setInline(macroBlock.isInline());
        return macroTransformationContext;
    }

    protected Macro<?> getMacro(MacroBlock macroBlock) {
        Syntax syntax = macroBlock.getSyntaxMetadata().orElse(this.renderingContext.getDefaultSyntax());
        MacroId macroId = new MacroId(macroBlock.getId(), syntax);
        Macro macro = null;
        try {
            macro = this.macroManager.getMacro(macroId);
        }
        catch (MacroLookupException macroLookupException) {
            // empty catch block
        }
        return macro;
    }

    protected List<RequiredRightAnalysisResult> analyzeMacroContent(MacroBlock macroBlock, String content) throws RequiredRightsException {
        return this.analyzeMacroContent(macroBlock, content, null);
    }

    protected List<RequiredRightAnalysisResult> analyzeMacroContent(MacroBlock macroBlock, String content, Syntax syntax) throws RequiredRightsException {
        MetaData metaData = null;
        if (macroBlock.getRoot() instanceof XDOM) {
            metaData = new MetaData(((XDOM)macroBlock.getRoot()).getMetaData().getMetaData());
        }
        MacroTransformationContext transformationContext = this.getTransformationContext(macroBlock);
        try {
            XDOM xdom = this.macroContentParser.parse(content, syntax, transformationContext, false, metaData, macroBlock.isInline());
            return this.xdomRequiredRightAnalyzer.analyze((Object)xdom);
        }
        catch (Exception e) {
            throw new RequiredRightsException("Failed to analyze macro content", (Throwable)e);
        }
    }

    protected EntityReference extractSourceReference(Block source) {
        EntityReference result = null;
        MetaDataBlock metaDataBlock = (MetaDataBlock)source.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("entityReference"), Block.Axes.ANCESTOR);
        if (metaDataBlock != null && metaDataBlock.getMetaData().getMetaData("entityReference") instanceof EntityReference) {
            result = (EntityReference)metaDataBlock.getMetaData().getMetaData("entityReference");
        } else {
            metaDataBlock = (MetaDataBlock)source.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("source"), Block.Axes.ANCESTOR);
            if (metaDataBlock != null) {
                result = this.documentReferenceResolver.resolve((Object)((String)metaDataBlock.getMetaData().getMetaData("source")), new Object[0]);
            }
        }
        return result;
    }

    protected RequiredRightAnalysisResult reportAnalysisError(MacroBlock macroBlock, Exception e) {
        return new RequiredRightAnalysisResult(this.extractSourceReference((Block)macroBlock), this.translationBlockSupplierProvider.get((Object)"security.requiredrights.macro.analyzer.error", new Object[]{macroBlock.getId(), ExceptionUtils.getRootCauseMessage((Throwable)e)}), this.macroBlockBlockSupplierProvider.get((Object)macroBlock, new Object[0]), List.of(RequiredRight.MAYBE_PROGRAM));
    }
}

