/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.validation.edit.EditConfirmationChecker;
import org.xwiki.model.validation.edit.EditConfirmationCheckerResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.internal.RequiredRightsChangedFilter;
import org.xwiki.platform.security.requiredrights.internal.RequiredRightsChangedResult;
import org.xwiki.platform.security.requiredrights.internal.configuration.RequiredRightsConfiguration;
import org.xwiki.platform.security.requiredrights.internal.editconfirmationchecker.RequiredRightAnalysisResultSkipValue;
import org.xwiki.platform.security.requiredrights.internal.editconfirmationchecker.RequiredRightsChangedResultSkipValue;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
@Named(value="requiredRights")
public class RequiredRightsEditConfirmationChecker
implements EditConfirmationChecker {
    @Inject
    private RequiredRightAnalyzer<XWikiDocument> analyzer;
    @Inject
    private RequiredRightsChangedFilter requiredRightsChangedFilter;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private TemplateManager templateManager;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private RequiredRightsConfiguration requiredRightsConfiguration;
    @Inject
    @Named(value="html/5.0")
    private BlockRenderer htmlBlockRender;

    public Optional<EditConfirmationCheckerResult> check() {
        Optional<Object> checkResult;
        RequiredRightsConfiguration.RequiredRightDocumentProtection documentProtection = this.requiredRightsConfiguration.getDocumentProtection();
        if (documentProtection == RequiredRightsConfiguration.RequiredRightDocumentProtection.NONE) {
            checkResult = Optional.empty();
        } else {
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument tdoc = (XWikiDocument)context.get((Object)"tdoc");
            if (!this.authorization.hasAccess(Right.EDIT, (EntityReference)tdoc.getDocumentReference()) || tdoc.isNew()) {
                checkResult = Optional.empty();
            } else {
                try {
                    RequiredRightsChangedResult analysisResults = this.requiredRightsChangedFilter.filter(tdoc.getAuthors(), this.analyzer.analyze((Object)tdoc));
                    if (analysisResults.isEmpty()) {
                        checkResult = Optional.empty();
                    } else {
                        this.scriptContextManager.getCurrentScriptContext().setAttribute("analysisResults", analysisResults, 200);
                        XDOM message = this.templateManager.executeNoException("security/requiredrights/requiredRightsEditConfirmationChecker.vm");
                        checkResult = Optional.of(new EditConfirmationCheckerResult((Block)message, false, (Serializable)this.getRequiredRightsChangedSkipValue(analysisResults)));
                    }
                }
                catch (RequiredRightsException e) {
                    this.scriptContextManager.getCurrentScriptContext().setAttribute("exception", (Object)e, 200);
                    XDOM message = this.templateManager.executeNoException("security/requiredrights/requiredRightsEditConfirmationCheckerError.vm");
                    checkResult = Optional.of(new EditConfirmationCheckerResult((Block)message, false));
                }
            }
        }
        return checkResult;
    }

    private RequiredRightsChangedResultSkipValue getRequiredRightsChangedSkipValue(RequiredRightsChangedResult analysisResults) {
        return new RequiredRightsChangedResultSkipValue(analysisResults.getAddedRights(), analysisResults.getRemovedRights(), this.convertToString(analysisResults.getAdded()), this.convertToString(analysisResults.getRemoved()));
    }

    private List<RequiredRightAnalysisResultSkipValue> convertToString(Set<RequiredRightAnalysisResult> results) {
        return results.stream().map(it -> new RequiredRightAnalysisResultSkipValue(it.getEntityReference(), it.getRequiredRights(), this.render(it.getSummaryMessage()), this.render(it.getDetailedMessage()))).collect(Collectors.toList());
    }

    private String render(Block detailedMessage) {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.htmlBlockRender.render(detailedMessage, (WikiPrinter)printer);
        return printer.toString();
    }
}

