/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.internal.RequiredRightChangeSuggestion;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRight;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRights;

@Singleton
@Component(roles={RequiredRightsChangeSuggestionManager.class})
public class RequiredRightsChangeSuggestionManager {
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;

    public List<RequiredRightChangeSuggestion> getSuggestedOperations(DocumentReference documentReference, DocumentRequiredRights currentRights, List<RequiredRightAnalysisResult> analysisResults) {
        DocumentRequiredRight configuredRight = currentRights.rights().stream().filter(this::isConsideredRight).reduce(null, RequiredRightsChangeSuggestionManager::getMorePowerfulRight);
        DocumentRequiredRight definitelyRequiredRight = this.getMostPowerfulConsideredRequiredRight(analysisResults, false);
        DocumentRequiredRight maybeRequiredRight = this.getMostPowerfulConsideredRequiredRight(analysisResults, true);
        return this.getRightOperations(documentReference, configuredRight, definitelyRequiredRight, maybeRequiredRight);
    }

    private DocumentRequiredRight getMostPowerfulConsideredRequiredRight(List<RequiredRightAnalysisResult> requiredRightAnalysisResults, boolean manualReviewNeeded) {
        return requiredRightAnalysisResults.stream().flatMap(result -> result.getRequiredRights().stream()).filter(result -> result.isManualReviewNeeded() == manualReviewNeeded).map(RequiredRight::toDocumentRequiredRight).filter(this::isConsideredRight).reduce(null, RequiredRightsChangeSuggestionManager::getMorePowerfulRight);
    }

    private List<RequiredRightChangeSuggestion> getRightOperations(DocumentReference documentReference, DocumentRequiredRight configuredRight, DocumentRequiredRight definitelyRequiredRight, DocumentRequiredRight maybeRequiredRight) {
        ArrayList<RequiredRightChangeSuggestion> operations = new ArrayList<RequiredRightChangeSuggestion>();
        if (RequiredRightsChangeSuggestionManager.isNewRightMorePowerFull(configuredRight, definitelyRequiredRight)) {
            operations.add(this.buildRightOperation(documentReference, true, configuredRight, definitelyRequiredRight, false));
        }
        if (RequiredRightsChangeSuggestionManager.isNewRightMorePowerFull(configuredRight, maybeRequiredRight) && RequiredRightsChangeSuggestionManager.isNewRightMorePowerFull(definitelyRequiredRight, maybeRequiredRight)) {
            operations.add(this.buildRightOperation(documentReference, true, configuredRight, maybeRequiredRight, true));
        }
        if (RequiredRightsChangeSuggestionManager.isNewRightMorePowerFull(definitelyRequiredRight, configuredRight)) {
            boolean maybeIsHigherThanDefinitely = RequiredRightsChangeSuggestionManager.isNewRightMorePowerFull(definitelyRequiredRight, maybeRequiredRight);
            operations.add(this.buildRightOperation(documentReference, false, configuredRight, definitelyRequiredRight, maybeIsHigherThanDefinitely));
            if (maybeIsHigherThanDefinitely && RequiredRightsChangeSuggestionManager.isNewRightMorePowerFull(maybeRequiredRight, configuredRight)) {
                operations.add(this.buildRightOperation(documentReference, false, configuredRight, maybeRequiredRight, false));
            }
        }
        return operations;
    }

    private RequiredRightChangeSuggestion buildRightOperation(DocumentReference documentReference, boolean increasesRights, DocumentRequiredRight rightToRemove, DocumentRequiredRight rightToAdd, boolean requiresManualReview) {
        boolean hasPermission = this.contextualAuthorizationManager.hasAccess(Right.EDIT, (EntityReference)documentReference) && (rightToAdd == null || this.hasAccess(documentReference, rightToAdd));
        return new RequiredRightChangeSuggestion(increasesRights, rightToRemove, rightToAdd, requiresManualReview, hasPermission);
    }

    private boolean hasAccess(DocumentReference documentReference, DocumentRequiredRight rightToAdd) {
        if (rightToAdd.scope() == null) {
            return this.contextualAuthorizationManager.hasAccess(rightToAdd.right(), null);
        }
        return this.contextualAuthorizationManager.hasAccess(rightToAdd.right(), documentReference.extractReference(rightToAdd.scope()));
    }

    private static boolean isNewRightMorePowerFull(DocumentRequiredRight existingRight, DocumentRequiredRight newRight) {
        return newRight != null && (existingRight == null || newRight.right().getImpliedRights() != null && newRight.right().getImpliedRights().contains(existingRight.right()));
    }

    private static DocumentRequiredRight getMorePowerfulRight(DocumentRequiredRight right1, DocumentRequiredRight right2) {
        return RequiredRightsChangeSuggestionManager.isNewRightMorePowerFull(right1, right2) ? right2 : right1;
    }

    private boolean isConsideredRight(DocumentRequiredRight documentRequiredRight) {
        return List.of(Right.SCRIPT, Right.ADMIN, Right.PROGRAM).contains(documentRequiredRight.right()) && (!documentRequiredRight.right().equals(Right.ADMIN) || documentRequiredRight.scope() == EntityType.WIKI);
    }
}

