/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights;

import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.rendering.block.Block;
import org.xwiki.text.XWikiToStringBuilder;

public class RequiredRightAnalysisResult {
    private final EntityReference entityReference;
    private final Supplier<Block> summaryMessageProvider;
    private final Supplier<Block> detailedMessageProvider;
    private final List<RequiredRight> requiredRights;

    public RequiredRightAnalysisResult(EntityReference entityReference, Supplier<Block> summaryMessageProvider, Supplier<Block> detailedMessageProvider, List<RequiredRight> requiredRights) {
        this.entityReference = entityReference;
        this.summaryMessageProvider = summaryMessageProvider;
        this.detailedMessageProvider = detailedMessageProvider;
        this.requiredRights = requiredRights;
    }

    public EntityReference getEntityReference() {
        return this.entityReference;
    }

    public Block getSummaryMessage() {
        return this.summaryMessageProvider.get();
    }

    public Block getDetailedMessage() {
        return this.detailedMessageProvider.get();
    }

    public List<RequiredRight> getRequiredRights() {
        return this.requiredRights;
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("entityReference", (Object)this.getEntityReference()).append("summaryMessageProvider", (Object)this.getSummaryMessage()).append("detailedMessageProvider", (Object)this.getDetailedMessage()).append("requiredRights", this.getRequiredRights()).toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RequiredRightAnalysisResult that = (RequiredRightAnalysisResult)object;
        return new EqualsBuilder().append((Object)this.entityReference, (Object)that.entityReference).append(this.requiredRights, that.requiredRights).append(this.summaryMessageProvider, that.summaryMessageProvider).append(this.detailedMessageProvider, that.detailedMessageProvider).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.entityReference).append(this.requiredRights).append(this.summaryMessageProvider).append(this.detailedMessageProvider).toHashCode();
    }
}

