/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.EntityType;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRight;
import org.xwiki.stability.Unstable;
import org.xwiki.text.XWikiToStringBuilder;

public class RequiredRight
implements Serializable {
    public static final RequiredRight PROGRAM = new RequiredRight(Right.PROGRAM, null, false);
    public static final RequiredRight MAYBE_PROGRAM = new RequiredRight(Right.PROGRAM, null, true);
    public static final RequiredRight SCRIPT = new RequiredRight(Right.SCRIPT, EntityType.DOCUMENT, false);
    public static final RequiredRight MAYBE_SCRIPT = new RequiredRight(Right.SCRIPT, EntityType.DOCUMENT, true);
    public static final RequiredRight WIKI_ADMIN = new RequiredRight(Right.ADMIN, EntityType.WIKI, false);
    public static final List<RequiredRight> SCRIPT_AND_MAYBE_PROGRAM = List.of(SCRIPT, MAYBE_PROGRAM);
    private static final long serialVersionUID = 4837678565544747071L;
    private final Right right;
    private final EntityType entityType;
    private final boolean manualReviewNeeded;

    public RequiredRight(Right right, EntityType entityType, boolean manualReviewNeeded) {
        this.right = right;
        this.entityType = entityType;
        this.manualReviewNeeded = manualReviewNeeded;
    }

    public Right getRight() {
        return this.right;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public boolean isManualReviewNeeded() {
        return this.manualReviewNeeded;
    }

    @Unstable
    public DocumentRequiredRight toDocumentRequiredRight() {
        return new DocumentRequiredRight(this.right, this.entityType);
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("right", (Object)this.getRight()).append("entityType", (Object)this.getEntityType()).append("manualReviewNeeded", this.isManualReviewNeeded()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequiredRight that = (RequiredRight)o;
        return new EqualsBuilder().append(this.isManualReviewNeeded(), that.isManualReviewNeeded()).append((Object)this.getRight(), (Object)that.getRight()).append((Object)this.getEntityType(), (Object)that.getEntityType()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getRight()).append((Object)this.getEntityType()).append(this.isManualReviewNeeded()).toHashCode();
    }
}

