/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.internal.XWikiConstants;

@Component(roles={DocumentInitializerRightsManager.class})
@Singleton
public class DocumentInitializerRightsManager {
    private static final String XWIKI_ADMIN_GROUP_DOCUMENT_REFERENCE = "XWiki.XWikiAdminGroup";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;

    public boolean restrictToAdmin(XWikiDocument document) {
        boolean updated = false;
        List<Right> rights = List.of(Right.VIEW, Right.EDIT, Right.DELETE);
        if (this.fixBadlyInitializedRights(document, rights)) {
            updated = true;
        }
        if (document.getXObjects((EntityReference)XWikiConstants.LOCAL_CLASS_REFERENCE).isEmpty()) {
            updated = updated || this.initializeRights(document, rights);
        }
        return updated;
    }

    private boolean initializeRights(XWikiDocument document, List<Right> rights) {
        boolean updated = false;
        try {
            BaseObject object = document.newXObject((EntityReference)XWikiConstants.LOCAL_CLASS_REFERENCE, (XWikiContext)this.xcontextProvider.get());
            this.setRights(object, rights);
            updated = true;
        }
        catch (XWikiException e) {
            this.logger.error(String.format("Error adding a [%s] object to the document [%s]", XWikiConstants.LOCAL_CLASS_REFERENCE, document.getDocumentReference()));
        }
        return updated;
    }

    private boolean fixBadlyInitializedRights(XWikiDocument document, List<Right> rights) {
        BaseObject object;
        boolean updated = false;
        if (document.getXObjects((EntityReference)XWikiConstants.LOCAL_CLASS_REFERENCE).size() == 1 && StringUtils.isEmpty((CharSequence)(object = document.getXObject((EntityReference)XWikiConstants.LOCAL_CLASS_REFERENCE)).getStringValue("levels")) && StringUtils.isEmpty((CharSequence)object.getLargeStringValue("groups"))) {
            this.setRights(object, rights);
            updated = true;
        }
        return updated;
    }

    private void setRights(BaseObject object, List<Right> rights) {
        object.setLargeStringValue("groups", XWIKI_ADMIN_GROUP_DOCUMENT_REFERENCE);
        object.setStringValue("levels", rights.stream().map(Right::getName).collect(Collectors.joining(",")));
        object.setIntValue("allow", 1);
    }
}

