/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.UserCreatingDocumentEvent;
import com.xpn.xwiki.internal.event.UserDeletingDocumentEvent;
import com.xpn.xwiki.internal.event.UserEvent;
import com.xpn.xwiki.internal.event.UserUpdatingDocumentEvent;
import com.xpn.xwiki.internal.mandatory.XWikiGlobalRightsDocumentInitializer;
import com.xpn.xwiki.internal.mandatory.XWikiRightsDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.ElementInterface;
import com.xpn.xwiki.objects.classes.LevelsClass;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.internal.document.DocumentRequiredRightsReader;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.CancelableEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRight;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRights;
import org.xwiki.security.internal.XWikiConstants;

@Component
@Singleton
@Named(value="org.xwiki.security.authorization.internal.RightsFilterListener")
public class RightsFilterListener
extends AbstractEventListener {
    public static final String NAME = "org.xwiki.security.authorization.internal.RightsFilterListener";
    @Inject
    private AuthorizationManager authorization;
    @Inject
    private DocumentRequiredRightsReader documentRequiredRightsReader;

    public RightsFilterListener() {
        super(NAME, new Event[]{new UserUpdatingDocumentEvent(), new UserCreatingDocumentEvent(), new UserDeletingDocumentEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        UserEvent userEvent = (UserEvent)event;
        this.checkModifiedRights(userEvent.getUserReference(), document, XWikiRightsDocumentInitializer.CLASS_REFERENCE, null);
        this.checkModifiedRights(userEvent.getUserReference(), document, XWikiGlobalRightsDocumentInitializer.CLASS_REFERENCE, (CancelableEvent)event);
        this.checkModifiedRequiredRights(userEvent.getUserReference(), document, (CancelableEvent)event);
    }

    private void checkModifiedRequiredRights(DocumentReference user, XWikiDocument document, CancelableEvent event) {
        DocumentRequiredRights requiredRights;
        XWikiDocument originalDocument = document.getOriginalDocument();
        DocumentRequiredRights originalRequiredRights = this.documentRequiredRightsReader.readRequiredRights(originalDocument);
        if (!originalRequiredRights.equals((Object)(requiredRights = this.documentRequiredRightsReader.readRequiredRights(document))) && requiredRights.enforce()) {
            for (DocumentRequiredRight requiredRight : requiredRights.rights()) {
                try {
                    this.authorization.checkAccess(requiredRight.right(), user, document.getDocumentReference().extractReference(requiredRight.scope()));
                }
                catch (AccessDeniedException e) {
                    event.cancel("The author doesn't have the right [%s] on the [%s] level that has been specified as required.".formatted(requiredRight.right().getName(), requiredRight.scope()));
                    break;
                }
            }
        }
    }

    private void checkModifiedRights(DocumentReference user, XWikiDocument document, LocalDocumentReference classReference, CancelableEvent event) {
        XWikiDocument originalDocument = document.getOriginalDocument();
        List originalRights = originalDocument.getXObjects((EntityReference)classReference);
        List rights = document.getXObjects((EntityReference)classReference);
        try {
            this.checkModifiedRights(user, document.getDocumentReference(), originalRights, rights);
        }
        catch (AccessDeniedException e) {
            if (event instanceof UserDeletingDocumentEvent) {
                event.cancel("Deleting the document have an impact on rights the author does not have");
            }
            this.cancel(document, originalRights, rights);
        }
    }

    private void cancel(XWikiDocument document, List<BaseObject> originalRights, List<BaseObject> rights) {
        for (int i = 0; i < originalRights.size() || i < rights.size(); ++i) {
            BaseObject rightObject;
            BaseObject originalRightObject = i < originalRights.size() ? originalRights.get(i) : null;
            BaseObject baseObject = rightObject = i < rights.size() ? rights.get(i) : null;
            if (originalRightObject != null) {
                document.getXObjectsToRemove().remove(originalRightObject);
                if (rightObject != null) {
                    rightObject.apply((ElementInterface)originalRightObject, true);
                    continue;
                }
                document.setXObject(originalRightObject.getNumber(), originalRightObject.clone());
                continue;
            }
            if (rightObject == null) continue;
            document.removeXObject(rightObject);
        }
    }

    private void checkModifiedRights(BaseObject rightObject, DocumentReference user, DocumentReference document) throws AccessDeniedException {
        if (rightObject != null) {
            for (String level : LevelsClass.getListFromString((String)rightObject.getStringValue("levels"))) {
                Right right = Right.toRight((String)level);
                if (right == Right.ILLEGAL) {
                    right = Right.PROGRAM;
                }
                if (rightObject.getXClassReference().getName().equals("XWikiRights")) {
                    this.authorization.checkAccess(right, user, (EntityReference)document);
                    continue;
                }
                if (document.getLocalDocumentReference().equals((Object)XWikiConstants.WIKI_DOC_REFERENCE)) {
                    this.authorization.checkAccess(right, user, (EntityReference)document.getWikiReference());
                    continue;
                }
                if (!document.getName().equals("WebPreferences")) continue;
                this.authorization.checkAccess(right, user, document.getParent());
            }
        }
    }

    private void checkModifiedRights(DocumentReference user, DocumentReference document, List<BaseObject> originalRightObjects, List<BaseObject> rightObjects) throws AccessDeniedException {
        for (int i = 0; i < originalRightObjects.size() || i < rightObjects.size(); ++i) {
            BaseObject rightObject;
            BaseObject originalRightObject = i < originalRightObjects.size() ? originalRightObjects.get(i) : null;
            BaseObject baseObject = rightObject = i < rightObjects.size() ? rightObjects.get(i) : null;
            if (Objects.equals(originalRightObject, rightObject)) continue;
            this.checkModifiedRights(originalRightObject, user, document);
            this.checkModifiedRights(rightObject, user, document);
        }
    }
}

