/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.EntityTypeNotSupportedException;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RightSet;
import org.xwiki.security.authorization.RuleState;
import org.xwiki.security.authorization.SecurityEntryReader;
import org.xwiki.security.authorization.SecurityEntryReaderExtra;
import org.xwiki.security.authorization.SecurityRule;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.internal.AbstractSecurityRuleEntry;
import org.xwiki.security.authorization.internal.AllowEditToNoOneRule;
import org.xwiki.security.authorization.internal.XWikiSecurityRule;
import org.xwiki.security.internal.GroupSecurityEntry;
import org.xwiki.text.XWikiToStringBuilder;

@Component
@Singleton
public class DefaultSecurityEntryReader
implements SecurityEntryReader {
    private static final SecurityRule DENY_EDIT = new AllowEditToNoOneRule();
    private static final Set<Right> MAINWIKIOWNER_RIGHTS = new RightSet(new Right[]{Right.PROGRAM});
    private static final Set<Right> OWNER_RIGHTS = new RightSet(new Right[]{Right.ADMIN});
    private static final Set<Right> CREATOR_RIGHTS = new RightSet(new Right[]{Right.CREATOR});
    @Inject
    @Named(value="user")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityRuleEntry read(SecurityReference entity) throws AuthorizationException {
        DocumentReference documentReference;
        WikiReference wikiReference;
        if (entity == null) {
            return null;
        }
        if (entity.getOriginalReference() == null) {
            return new InternalSecurityRuleEntry(entity, Collections.emptyList());
        }
        Collection<SecurityRule> rules = this.getSecurityRules(documentReference, switch (entity.getType()) {
            case EntityType.WIKI -> {
                wikiReference = new WikiReference((EntityReference)entity);
                SpaceReference wikiSpace = new SpaceReference("XWiki", wikiReference);
                documentReference = new DocumentReference("XWikiPreferences", wikiSpace);
                yield new DocumentReference("XWikiGlobalRights", wikiSpace);
            }
            case EntityType.SPACE -> {
                wikiReference = new WikiReference(entity.extractReference(EntityType.WIKI));
                documentReference = new DocumentReference("WebPreferences", new SpaceReference((EntityReference)entity));
                yield new DocumentReference("XWikiGlobalRights", new SpaceReference("XWiki", wikiReference));
            }
            case EntityType.DOCUMENT -> {
                wikiReference = new WikiReference(entity.extractReference(EntityType.WIKI));
                documentReference = new DocumentReference((EntityReference)entity);
                yield new DocumentReference("XWikiRights", new SpaceReference("XWiki", wikiReference));
            }
            default -> throw new EntityTypeNotSupportedException(entity.getType(), (SecurityEntryReader)this);
        }, wikiReference);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        WikiReference currentWikiReference = xcontext.getWikiReference();
        try {
            xcontext.setWikiReference(wikiReference);
            List extras = ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(SecurityEntryReaderExtra.class);
            for (SecurityEntryReaderExtra extra : extras) {
                Collection extraRules = extra.read(entity);
                if (extraRules == null) continue;
                rules.addAll(extraRules);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup extra security entry readers", (Throwable)e);
        }
        finally {
            xcontext.setWikiReference(currentWikiReference);
        }
        return new InternalSecurityRuleEntry(entity, rules);
    }

    private XWikiDocument getDocument(DocumentReference documentReference) throws AuthorizationException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            XWikiDocument doc = context.getWiki().getDocument(documentReference, context);
            if (doc == null || doc.isNew()) {
                return null;
            }
            return doc;
        }
        catch (XWikiException e) {
            throw new AuthorizationException((EntityReference)documentReference, "Could not retrieve the document to check security access", (Throwable)e);
        }
    }

    private DocumentReference getWikiOwner(WikiReference wikiReference) throws AuthorizationException {
        String wikiOwner;
        block3: {
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            wikiOwner = null;
            try {
                wikiOwner = context.getWiki().getWikiOwner(wikiReference.getName(), context);
            }
            catch (XWikiException e) {
                if (e.getCode() == 2) break block3;
                throw new AuthorizationException((EntityReference)wikiReference, String.format("Could not retrieve the owner of the wiki [%s]", wikiReference.getName()), (Throwable)e);
            }
        }
        if (wikiOwner == null) {
            return null;
        }
        return this.resolver.resolve((Object)wikiOwner, new Object[]{wikiReference});
    }

    private Collection<SecurityRule> getSecurityRules(DocumentReference documentReference, DocumentReference classReference, WikiReference wikiReference) throws AuthorizationException {
        boolean isGlobalRightsReference = this.isGlobalRightsReference(documentReference);
        boolean isGlobalRightRequested = classReference.getName().equals("XWikiGlobalRights");
        XWikiDocument doc = this.getDocument(documentReference);
        List<SecurityRule> securityRules = this.getImpliedRules(documentReference, doc, isGlobalRightsReference, isGlobalRightRequested);
        if (doc == null) {
            return securityRules;
        }
        List baseObjects = doc.getXObjects(classReference);
        if (baseObjects != null) {
            for (BaseObject obj : baseObjects) {
                SecurityRule rule;
                if (obj == null) continue;
                try {
                    rule = XWikiSecurityRule.createNewRule(obj, this.resolver, wikiReference, isGlobalRightsReference && !isGlobalRightRequested);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                securityRules.add(rule);
            }
        }
        return securityRules;
    }

    private List<SecurityRule> getImpliedRules(DocumentReference documentReference, XWikiDocument document, boolean isGlobalRightsReference, boolean isGlobalRightRequested) throws AuthorizationException {
        DocumentReference creator;
        ArrayList<SecurityRule> rules = new ArrayList<SecurityRule>();
        if (isGlobalRightsReference) {
            if (isGlobalRightRequested) {
                this.addImpliedGlobalRule(documentReference, rules);
            } else {
                rules.add(DENY_EDIT);
            }
        }
        if (!isGlobalRightRequested && document != null && (creator = document.getCreatorReference()) != null && !"XWikiGuest".equals(creator.getName())) {
            rules.add(new XWikiSecurityRule(CREATOR_RIGHTS, RuleState.ALLOW, Collections.singleton(creator), null));
        }
        return rules;
    }

    private void addImpliedGlobalRule(DocumentReference documentReference, List<SecurityRule> rules) throws AuthorizationException {
        WikiReference documentWiki = documentReference.getWikiReference();
        DocumentReference owner = this.getWikiOwner(documentWiki);
        if (owner != null) {
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            if (context.isMainWiki(documentWiki.getName())) {
                rules.add(new XWikiSecurityRule(MAINWIKIOWNER_RIGHTS, RuleState.ALLOW, Collections.singleton(owner), null));
            } else {
                rules.add(new XWikiSecurityRule(OWNER_RIGHTS, RuleState.ALLOW, Collections.singleton(owner), null));
            }
        }
    }

    private boolean isGlobalRightsReference(DocumentReference documentReference) {
        return "WebPreferences".equals(documentReference.getName()) || "XWikiPreferences".equals(documentReference.getName()) && "XWiki".equals(documentReference.getParent().getName());
    }

    private final class InternalSecurityRuleEntry
    extends AbstractSecurityRuleEntry
    implements GroupSecurityEntry {
        private SecurityReference reference;
        private final Collection<SecurityRule> rules;

        private InternalSecurityRuleEntry(SecurityReference reference, Collection<SecurityRule> rules) {
            this.reference = reference;
            this.rules = Collections.unmodifiableCollection(rules);
        }

        public SecurityReference getReference() {
            return this.reference;
        }

        public void setGroupReference(GroupSecurityReference reference) {
            this.reference = reference;
        }

        public Collection<SecurityRule> getRules() {
            return this.rules;
        }

        public String toString() {
            XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
            builder.append("entity", (Object)this.reference);
            builder.append("rules", this.rules);
            return builder.toString();
        }
    }
}

