/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.internal.document.DocumentRequiredRightsReader;
import org.xwiki.internal.document.SimpleDocumentCache;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRights;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRightsManager;

@Component
@Singleton
public class DefaultDocumentRequiredRightsManager
implements DocumentRequiredRightsManager {
    private static final int DEFAULT_CAPACITY = 10000;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private DocumentRequiredRightsReader documentRequiredRightsReader;
    @Inject
    private SimpleDocumentCache<Optional<DocumentRequiredRights>, AuthorizationException> cache;
    @Inject
    private Logger logger;
    private final AtomicBoolean initializing = new AtomicBoolean();
    private final AtomicBoolean initialized = new AtomicBoolean();

    public Optional<DocumentRequiredRights> getRequiredRights(DocumentReference documentReference) throws AuthorizationException {
        if (documentReference != null) {
            if (this.initialized.getAcquire() || this.tryInitializeCache()) {
                return (Optional)this.cache.get(documentReference.withoutLocale(), this::loadRequiredRights);
            }
            return this.loadRequiredRights(documentReference.withoutLocale());
        }
        return Optional.empty();
    }

    private Optional<DocumentRequiredRights> loadRequiredRights(DocumentReference documentReference) throws AuthorizationException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            XWikiDocument document = context.getWiki().getDocument(documentReference, context);
            if (!document.isNew()) {
                return Optional.of(this.documentRequiredRightsReader.readRequiredRights(document));
            }
        }
        catch (XWikiException e) {
            throw new AuthorizationException("Failed to load the document", (Throwable)e);
        }
        return Optional.empty();
    }

    private boolean tryInitializeCache() {
        if (!this.initializing.compareAndExchange(false, true)) {
            try {
                if (!this.initialized.get()) {
                    LRUCacheConfiguration cacheConfiguration = new LRUCacheConfiguration("platform.security.authorization.requiredrights.cache", 10000);
                    this.cache.initializeCache((CacheConfiguration)cacheConfiguration);
                    this.initialized.set(true);
                }
                boolean cacheConfiguration = true;
                return cacheConfiguration;
            }
            catch (Exception e) {
                this.logger.warn("Failed to initialize the required rights cache: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                this.logger.debug("Full stack trace of required rights cache initialization failure:", (Throwable)e);
            }
            finally {
                this.initializing.set(false);
            }
        }
        return false;
    }
}

