/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
public class DefaultContextualAuthorizationManager
implements ContextualAuthorizationManager {
    private static final Set<Right> CONTENT_AUTHOR_RIGHTS = new HashSet<Right>(Arrays.asList(Right.SCRIPT, Right.PROGRAM));
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    @Named(value="current")
    private EntityReferenceResolver<EntityReference> resolver;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentAuthorizationManager documentAuthorizationManager;
    @Inject
    private Logger logger;

    public void checkAccess(Right right) throws AccessDeniedException {
        if (CONTENT_AUTHOR_RIGHTS.contains(right)) {
            this.checkAccess(right, this.getCurrentUser(right, null), (EntityReference)this.getCurrentAuthorDocumentReference(right));
        } else {
            this.checkAccess(right, this.getCurrentEntity());
        }
    }

    public void checkAccess(Right right, EntityReference entity) throws AccessDeniedException {
        DocumentReference user = this.getCurrentUser(right, entity);
        this.checkAccess(right, user, entity);
    }

    private void checkAccess(Right right, DocumentReference user, EntityReference entity) throws AccessDeniedException {
        if (!this.checkPreAccess(right)) {
            throw new AccessDeniedException(right, user, entity);
        }
        this.authorizationManager.checkAccess(right, user, this.getFullReference(entity));
    }

    public boolean hasAccess(Right right) {
        if (CONTENT_AUTHOR_RIGHTS.contains(right)) {
            return this.hasAccess(right, this.getCurrentUser(right, null), (EntityReference)this.getCurrentAuthorDocumentReference(right));
        }
        return this.hasAccess(right, this.getCurrentEntity());
    }

    public boolean hasAccess(Right right, EntityReference entity) {
        DocumentReference user = this.getCurrentUser(right, entity);
        return this.hasAccess(right, user, entity);
    }

    private boolean hasAccess(Right right, DocumentReference user, EntityReference entity) {
        return this.checkPreAccess(right) && this.authorizationManager.hasAccess(right, user, this.getFullReference(entity));
    }

    private EntityReference getFullReference(EntityReference reference) {
        return reference != null ? this.resolver.resolve((Object)reference, reference.getType(), new Object[0]) : null;
    }

    private boolean checkPreAccess(Right right) {
        if (CONTENT_AUTHOR_RIGHTS.contains(right)) {
            XWikiDocument doc = this.getProgrammingDocument();
            boolean restricted = this.renderingContext.isRestricted() || doc != null && doc.isRestricted();
            return !restricted && !this.hasDroppedProgrammingRight(right) && this.hasRequiredRight(right, doc);
        }
        return true;
    }

    private boolean hasDroppedProgrammingRight(Right right) {
        return right == Right.PROGRAM && ((XWikiContext)this.xcontextProvider.get()).hasDroppedPermissions();
    }

    private boolean hasRequiredRight(Right right, XWikiDocument programmingDocument) {
        if (programmingDocument != null) {
            try {
                return this.documentAuthorizationManager.hasRequiredRight(right, EntityType.DOCUMENT, programmingDocument.getDocumentReference());
            }
            catch (AuthorizationException e) {
                this.logger.error("Failed to load required rights for [{}]", (Object)programmingDocument.getDocumentReference(), (Object)e);
                return false;
            }
        }
        return true;
    }

    private DocumentReference getCurrentUser(Right right, EntityReference entity) {
        if (CONTENT_AUTHOR_RIGHTS.contains(right)) {
            XWikiDocument doc;
            XWikiDocument xWikiDocument = doc = entity == null ? this.getProgrammingDocument() : this.getDocument(entity);
            if (doc != null) {
                return this.getContentAuthor(doc);
            }
        }
        return ((XWikiContext)this.xcontextProvider.get()).getUserReference();
    }

    private DocumentReference getCurrentAuthorDocumentReference(Right right) {
        if (right == Right.PROGRAM) {
            return null;
        }
        XWikiDocument doc = this.getProgrammingDocument();
        return doc != null ? doc.getDocumentReference() : null;
    }

    private XWikiDocument getDocument(EntityReference entity) {
        if (entity == null) {
            return null;
        }
        EntityReference docEntity = entity.extractReference(EntityType.DOCUMENT);
        if (docEntity == null) {
            return null;
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            return xcontext.getWiki().getDocument(new DocumentReference(docEntity), xcontext);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private DocumentReference getContentAuthor(XWikiDocument doc) {
        DocumentReference user = doc.getContentAuthorReference();
        if (user != null && "XWikiGuest".equals(user.getName())) {
            user = null;
        }
        return user;
    }

    private EntityReference getCurrentEntity() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument doc = xcontext.getDoc();
        if (doc != null) {
            return doc.getDocumentReference();
        }
        return null;
    }

    private XWikiDocument getProgrammingDocument() {
        return ((XWikiContext)this.xcontextProvider.get()).getSecureDocument();
    }
}

