/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Role;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RightDescription;
import org.xwiki.security.authorization.UnableToRegisterRightException;
import org.xwiki.stability.Unstable;

@Role
public interface AuthorizationManager {
    public static final String SUPERADMIN_USER = "superadmin";

    @Unstable
    default public boolean isSuperAdmin(DocumentReference user) {
        return user != null && StringUtils.equalsIgnoreCase((CharSequence)user.getName(), (CharSequence)SUPERADMIN_USER);
    }

    public void checkAccess(Right var1, DocumentReference var2, EntityReference var3) throws AccessDeniedException;

    public boolean hasAccess(Right var1, DocumentReference var2, EntityReference var3);

    public Right register(RightDescription var1) throws UnableToRegisterRightException;

    default public Right register(RightDescription rightDescription, Set<Right> impliedByRights) throws UnableToRegisterRightException {
        return this.register(rightDescription);
    }

    default public void unregister(Right right) throws AuthorizationException {
    }
}

