/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.script;

import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authentication.RegistrationConfiguration;

@Component
@Named(value="security.registration")
@Singleton
public class RegistrationScriptService
implements ScriptService {
    public static final String ID = "registration";
    @Inject
    private RegistrationConfiguration registrationConfiguration;

    public int getPasswordMinimumLength() {
        return this.registrationConfiguration.getPasswordMinimumLength();
    }

    public Set<String> getPasswordRules() {
        return this.registrationConfiguration.getPasswordRules().stream().map(Enum::name).collect(Collectors.toSet());
    }

    public boolean isCaptchaRequired() {
        return this.registrationConfiguration.isCaptchaRequired();
    }

    public boolean isEmailValidationRequired() {
        return this.registrationConfiguration.isEmailValidationRequired();
    }

    public boolean isAutoLoginEnabled() {
        return this.registrationConfiguration.isAutoLoginEnabled();
    }

    public boolean isLoginEnabled() {
        return this.registrationConfiguration.isLoginEnabled();
    }
}

