/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.script;

import com.xpn.xwiki.XWikiContext;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authentication.AuthenticationAction;
import org.xwiki.security.authentication.AuthenticationConfiguration;
import org.xwiki.security.authentication.AuthenticationFailureManager;
import org.xwiki.security.authentication.AuthenticationFailureStrategy;
import org.xwiki.security.authentication.AuthenticationResourceReference;
import org.xwiki.security.authentication.ResetPasswordException;
import org.xwiki.security.authentication.ResetPasswordManager;
import org.xwiki.security.authentication.ResetPasswordRequestResponse;
import org.xwiki.security.authentication.RetrieveUsernameException;
import org.xwiki.security.authentication.RetrieveUsernameManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLNormalizer;
import org.xwiki.user.UserReference;

@Component
@Named(value="security.authentication")
@Singleton
public class AuthenticationScriptService
implements ScriptService {
    public static final String ID = "authentication";
    @Inject
    private AuthenticationFailureManager authenticationFailureManager;
    @Inject
    private AuthenticationConfiguration authenticationConfiguration;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private ContextualAuthorizationManager authorizationManager;
    @Inject
    private ResourceReferenceSerializer<ResourceReference, ExtendedURL> defaultResourceReferenceSerializer;
    @Inject
    private ResetPasswordManager resetPasswordManager;
    @Inject
    private RetrieveUsernameManager retrieveUsernameManager;
    @Inject
    @Named(value="contextpath")
    private URLNormalizer<ExtendedURL> urlNormalizer;
    @Inject
    private Logger logger;

    public String getForm(String username) {
        return this.authenticationFailureManager.getForm(username, (HttpServletRequest)((XWikiContext)this.contextProvider.get()).getRequest());
    }

    public String getErrorMessage(String username) {
        return this.authenticationFailureManager.getErrorMessage(username);
    }

    public Set<String> getAuthenticationFailureAvailableStrategies() {
        try {
            return this.componentManager.getInstanceMap(AuthenticationFailureStrategy.class).keySet();
        }
        catch (ComponentLookupException e) {
            this.logger.error("Error while getting the list of available authentication strategies.");
            return Collections.emptySet();
        }
    }

    public AuthenticationConfiguration getAuthenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public void resetAuthenticationFailureCounter(String username) {
        if (this.authorizationManager.hasAccess(Right.PROGRAM)) {
            this.authenticationFailureManager.resetAuthenticationFailureCounter(username);
        }
    }

    public String getAuthenticationURL(String action, Map<String, Object> params) {
        try {
            AuthenticationAction authenticationAction = AuthenticationAction.getFromRequestParameter((String)action);
            AuthenticationResourceReference resourceReference = new AuthenticationResourceReference(((XWikiContext)this.contextProvider.get()).getWikiReference(), authenticationAction);
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    resourceReference.addParameter(entry.getKey(), entry.getValue());
                }
            }
            ExtendedURL extendedURL = (ExtendedURL)this.defaultResourceReferenceSerializer.serialize((ResourceReference)resourceReference);
            return ((ExtendedURL)this.urlNormalizer.normalize(extendedURL)).serialize();
        }
        catch (IllegalArgumentException | SerializeResourceReferenceException | UnsupportedResourceReferenceException e) {
            this.logger.error("Error while getting authentication URL for action [{}].", (Object)action, (Object)e);
            return null;
        }
    }

    public void requestResetPassword(UserReference user) throws ResetPasswordException {
        if (this.authorizationManager.hasAccess(Right.PROGRAM)) {
            ResetPasswordRequestResponse resetPasswordRequestResponse = this.resetPasswordManager.requestResetPassword(user);
            this.resetPasswordManager.sendResetPasswordEmailRequest(resetPasswordRequestResponse);
        }
    }

    public String checkVerificationCode(UserReference user, String verificationCode) throws ResetPasswordException {
        return this.resetPasswordManager.checkVerificationCode(user, verificationCode).getVerificationCode();
    }

    public void resetPassword(UserReference user, String verificationCode, String newPassword) throws ResetPasswordException {
        this.resetPasswordManager.checkVerificationCode(user, verificationCode);
        this.resetPasswordManager.resetPassword(user, newPassword);
    }

    public void retrieveUsernameAndSendEmail(String userEmail) throws RetrieveUsernameException {
        Set users = this.retrieveUsernameManager.findUsers(userEmail);
        if (!users.isEmpty()) {
            this.retrieveUsernameManager.sendRetrieveUsernameEmail(userEmail, users);
        }
    }
}

