/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal.resource;

import com.xpn.xwiki.XWikiContext;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.security.authentication.AuthenticationAction;
import org.xwiki.security.authentication.AuthenticationResourceReference;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.AbstractResourceReferenceResolver;

@Component
@Named(value="authenticate")
@Singleton
public class AuthenticationResourceReferenceResolver
extends AbstractResourceReferenceResolver {
    @Inject
    private Provider<XWikiContext> contextProvider;

    public AuthenticationResourceReference resolve(ExtendedURL representation, ResourceType resourceType, Map<String, Object> parameters) throws CreateResourceReferenceException, UnsupportedResourceReferenceException {
        AuthenticationResourceReference result;
        List segments = representation.getSegments();
        WikiReference wikiReference = new WikiReference(((XWikiContext)this.contextProvider.get()).getMainXWiki());
        if (segments.size() == 1) {
            result = new AuthenticationResourceReference(wikiReference, this.getAuthenticationAction((String)segments.get(0)));
            this.copyParameters(representation, (ResourceReference)result);
        } else if (segments.size() == 3 && "wiki".equals(segments.get(0))) {
            wikiReference = new WikiReference((String)segments.get(1));
            result = new AuthenticationResourceReference(wikiReference, this.getAuthenticationAction((String)segments.get(2)));
            this.copyParameters(representation, (ResourceReference)result);
        } else {
            throw new CreateResourceReferenceException(String.format("Invalid Authentication URL format: [%s]", representation.toString()));
        }
        return result;
    }

    private AuthenticationAction getAuthenticationAction(String actionName) throws CreateResourceReferenceException {
        try {
            return AuthenticationAction.getFromRequestParameter((String)actionName);
        }
        catch (IllegalArgumentException e) {
            throw new CreateResourceReferenceException(String.format("Cannot find an authentication action for name [%s]", actionName));
        }
    }
}

